/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessorsRequest extends ManagedBlockchainRequest implements
        ToCopyableBuilder<ListAccessorsRequest.Builder, ListAccessorsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAccessorsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAccessorsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(ListAccessorsRequest::networkTypeAsString))
            .setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("networkType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, NETWORK_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String networkType;

    private ListAccessorsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.networkType = builder.networkType;
    }

    /**
     * <p>
     * The maximum number of accessors to list.
     * </p>
     * 
     * @return The maximum number of accessors to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The blockchain network that the <code>Accessor</code> token is created for.
     * </p>
     * <note>
     * <p>
     * Use the value <code>ETHEREUM_MAINNET_AND_GOERLI</code> for all existing <code>Accessors</code> tokens that were
     * created before the <code>networkType</code> property was introduced.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link AccessorNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #networkTypeAsString}.
     * </p>
     * 
     * @return The blockchain network that the <code>Accessor</code> token is created for.</p> <note>
     *         <p>
     *         Use the value <code>ETHEREUM_MAINNET_AND_GOERLI</code> for all existing <code>Accessors</code> tokens
     *         that were created before the <code>networkType</code> property was introduced.
     *         </p>
     * @see AccessorNetworkType
     */
    public final AccessorNetworkType networkType() {
        return AccessorNetworkType.fromValue(networkType);
    }

    /**
     * <p>
     * The blockchain network that the <code>Accessor</code> token is created for.
     * </p>
     * <note>
     * <p>
     * Use the value <code>ETHEREUM_MAINNET_AND_GOERLI</code> for all existing <code>Accessors</code> tokens that were
     * created before the <code>networkType</code> property was introduced.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkType} will
     * return {@link AccessorNetworkType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #networkTypeAsString}.
     * </p>
     * 
     * @return The blockchain network that the <code>Accessor</code> token is created for.</p> <note>
     *         <p>
     *         Use the value <code>ETHEREUM_MAINNET_AND_GOERLI</code> for all existing <code>Accessors</code> tokens
     *         that were created before the <code>networkType</code> property was introduced.
     *         </p>
     * @see AccessorNetworkType
     */
    public final String networkTypeAsString() {
        return networkType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(networkTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessorsRequest)) {
            return false;
        }
        ListAccessorsRequest other = (ListAccessorsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(networkTypeAsString(), other.networkTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessorsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("NetworkType", networkTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("networkType", NETWORK_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccessorsRequest, T> g) {
        return obj -> g.apply((ListAccessorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessorsRequest> {
        /**
         * <p>
         * The maximum number of accessors to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of accessors to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The blockchain network that the <code>Accessor</code> token is created for.
         * </p>
         * <note>
         * <p>
         * Use the value <code>ETHEREUM_MAINNET_AND_GOERLI</code> for all existing <code>Accessors</code> tokens that
         * were created before the <code>networkType</code> property was introduced.
         * </p>
         * </note>
         * 
         * @param networkType
         *        The blockchain network that the <code>Accessor</code> token is created for.</p> <note>
         *        <p>
         *        Use the value <code>ETHEREUM_MAINNET_AND_GOERLI</code> for all existing <code>Accessors</code> tokens
         *        that were created before the <code>networkType</code> property was introduced.
         *        </p>
         * @see AccessorNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorNetworkType
         */
        Builder networkType(String networkType);

        /**
         * <p>
         * The blockchain network that the <code>Accessor</code> token is created for.
         * </p>
         * <note>
         * <p>
         * Use the value <code>ETHEREUM_MAINNET_AND_GOERLI</code> for all existing <code>Accessors</code> tokens that
         * were created before the <code>networkType</code> property was introduced.
         * </p>
         * </note>
         * 
         * @param networkType
         *        The blockchain network that the <code>Accessor</code> token is created for.</p> <note>
         *        <p>
         *        Use the value <code>ETHEREUM_MAINNET_AND_GOERLI</code> for all existing <code>Accessors</code> tokens
         *        that were created before the <code>networkType</code> property was introduced.
         *        </p>
         * @see AccessorNetworkType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorNetworkType
         */
        Builder networkType(AccessorNetworkType networkType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessorsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            networkType(model.networkType);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(AccessorNetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccessorsRequest build() {
            return new ListAccessorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
