/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMembersRequest extends ManagedBlockchainRequest implements
        ToCopyableBuilder<ListMembersRequest.Builder, ListMembersRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkId").getter(getter(ListMembersRequest::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListMembersRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListMembersRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<Boolean> IS_OWNED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsOwned").getter(getter(ListMembersRequest::isOwned)).setter(setter(Builder::isOwned))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isOwned").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListMembersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMembersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, NAME_FIELD,
            STATUS_FIELD, IS_OWNED_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String networkId;

    private final String name;

    private final String status;

    private final Boolean isOwned;

    private final Integer maxResults;

    private final String nextToken;

    private ListMembersRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.name = builder.name;
        this.status = builder.status;
        this.isOwned = builder.isOwned;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the network for which to list members.
     * </p>
     * 
     * @return The unique identifier of the network for which to list members.
     */
    public final String networkId() {
        return networkId;
    }

    /**
     * <p>
     * The optional name of the member to list.
     * </p>
     * 
     * @return The optional name of the member to list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional status specifier. If provided, only members currently in this status are listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return An optional status specifier. If provided, only members currently in this status are listed.
     * @see MemberStatus
     */
    public final MemberStatus status() {
        return MemberStatus.fromValue(status);
    }

    /**
     * <p>
     * An optional status specifier. If provided, only members currently in this status are listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return An optional status specifier. If provided, only members currently in this status are listed.
     * @see MemberStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An optional Boolean value. If provided, the request is limited either to members that the current Amazon Web
     * Services account owns (<code>true</code>) or that other Amazon Web Services accountsn own (<code>false</code>).
     * If omitted, all members are listed.
     * </p>
     * 
     * @return An optional Boolean value. If provided, the request is limited either to members that the current Amazon
     *         Web Services account owns (<code>true</code>) or that other Amazon Web Services accountsn own (
     *         <code>false</code>). If omitted, all members are listed.
     */
    public final Boolean isOwned() {
        return isOwned;
    }

    /**
     * <p>
     * The maximum number of members to return in the request.
     * </p>
     * 
     * @return The maximum number of members to return in the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isOwned());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersRequest)) {
            return false;
        }
        ListMembersRequest other = (ListMembersRequest) obj;
        return Objects.equals(networkId(), other.networkId()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(isOwned(), other.isOwned())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMembersRequest").add("NetworkId", networkId()).add("Name", name())
                .add("Status", statusAsString()).add("IsOwned", isOwned()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "IsOwned":
            return Optional.ofNullable(clazz.cast(isOwned()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("networkId", NETWORK_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("isOwned", IS_OWNED_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMembersRequest, T> g) {
        return obj -> g.apply((ListMembersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMembersRequest> {
        /**
         * <p>
         * The unique identifier of the network for which to list members.
         * </p>
         * 
         * @param networkId
         *        The unique identifier of the network for which to list members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * <p>
         * The optional name of the member to list.
         * </p>
         * 
         * @param name
         *        The optional name of the member to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional status specifier. If provided, only members currently in this status are listed.
         * </p>
         * 
         * @param status
         *        An optional status specifier. If provided, only members currently in this status are listed.
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder status(String status);

        /**
         * <p>
         * An optional status specifier. If provided, only members currently in this status are listed.
         * </p>
         * 
         * @param status
         *        An optional status specifier. If provided, only members currently in this status are listed.
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder status(MemberStatus status);

        /**
         * <p>
         * An optional Boolean value. If provided, the request is limited either to members that the current Amazon Web
         * Services account owns (<code>true</code>) or that other Amazon Web Services accountsn own (<code>false</code>
         * ). If omitted, all members are listed.
         * </p>
         * 
         * @param isOwned
         *        An optional Boolean value. If provided, the request is limited either to members that the current
         *        Amazon Web Services account owns (<code>true</code>) or that other Amazon Web Services accountsn own (
         *        <code>false</code>). If omitted, all members are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOwned(Boolean isOwned);

        /**
         * <p>
         * The maximum number of members to return in the request.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of members to return in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainRequest.BuilderImpl implements Builder {
        private String networkId;

        private String name;

        private String status;

        private Boolean isOwned;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersRequest model) {
            super(model);
            networkId(model.networkId);
            name(model.name);
            status(model.status);
            isOwned(model.isOwned);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getNetworkId() {
            return networkId;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getIsOwned() {
            return isOwned;
        }

        public final void setIsOwned(Boolean isOwned) {
            this.isOwned = isOwned;
        }

        @Override
        public final Builder isOwned(Boolean isOwned) {
            this.isOwned = isOwned;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMembersRequest build() {
            return new ListMembersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
