/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of log configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogConfigurations implements SdkPojo, Serializable,
        ToCopyableBuilder<LogConfigurations.Builder, LogConfigurations> {
    private static final SdkField<LogConfiguration> CLOUDWATCH_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("Cloudwatch")
            .getter(getter(LogConfigurations::cloudwatch)).setter(setter(Builder::cloudwatch))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cloudwatch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUDWATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LogConfiguration cloudwatch;

    private LogConfigurations(BuilderImpl builder) {
        this.cloudwatch = builder.cloudwatch;
    }

    /**
     * <p>
     * Parameters for publishing logs to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return Parameters for publishing logs to Amazon CloudWatch Logs.
     */
    public final LogConfiguration cloudwatch() {
        return cloudwatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfigurations)) {
            return false;
        }
        LogConfigurations other = (LogConfigurations) obj;
        return Objects.equals(cloudwatch(), other.cloudwatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogConfigurations").add("Cloudwatch", cloudwatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cloudwatch":
            return Optional.ofNullable(clazz.cast(cloudwatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cloudwatch", CLOUDWATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogConfigurations, T> g) {
        return obj -> g.apply((LogConfigurations) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogConfigurations> {
        /**
         * <p>
         * Parameters for publishing logs to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param cloudwatch
         *        Parameters for publishing logs to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatch(LogConfiguration cloudwatch);

        /**
         * <p>
         * Parameters for publishing logs to Amazon CloudWatch Logs.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #cloudwatch(LogConfiguration)}.
         * 
         * @param cloudwatch
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatch(LogConfiguration)
         */
        default Builder cloudwatch(Consumer<LogConfiguration.Builder> cloudwatch) {
            return cloudwatch(LogConfiguration.builder().applyMutation(cloudwatch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LogConfiguration cloudwatch;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfigurations model) {
            cloudwatch(model.cloudwatch);
        }

        public final LogConfiguration.Builder getCloudwatch() {
            return cloudwatch != null ? cloudwatch.toBuilder() : null;
        }

        public final void setCloudwatch(LogConfiguration.BuilderImpl cloudwatch) {
            this.cloudwatch = cloudwatch != null ? cloudwatch.build() : null;
        }

        @Override
        public final Builder cloudwatch(LogConfiguration cloudwatch) {
            this.cloudwatch = cloudwatch;
            return this;
        }

        @Override
        public LogConfigurations build() {
            return new LogConfigurations(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
