/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.MarketplaceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEntityResponse
extends MarketplaceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeEntityResponse> {
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEntityResponse.getter(DescribeEntityResponse::entityType)).setter(DescribeEntityResponse.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityType").build()}).build();
    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEntityResponse.getter(DescribeEntityResponse::entityIdentifier)).setter(DescribeEntityResponse.setter(Builder::entityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEntityResponse.getter(DescribeEntityResponse::entityArn)).setter(DescribeEntityResponse.setter(Builder::entityArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityArn").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEntityResponse.getter(DescribeEntityResponse::lastModifiedDate)).setter(DescribeEntityResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeEntityResponse.getter(DescribeEntityResponse::details)).setter(DescribeEntityResponse.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPE_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_ARN_FIELD, LAST_MODIFIED_DATE_FIELD, DETAILS_FIELD));
    private final String entityType;
    private final String entityIdentifier;
    private final String entityArn;
    private final String lastModifiedDate;
    private final String details;

    private DescribeEntityResponse(BuilderImpl builder) {
        super(builder);
        this.entityType = builder.entityType;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityArn = builder.entityArn;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.details = builder.details;
    }

    public String entityType() {
        return this.entityType;
    }

    public String entityIdentifier() {
        return this.entityIdentifier;
    }

    public String entityArn() {
        return this.entityArn;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEntityResponse)) {
            return false;
        }
        DescribeEntityResponse other = (DescribeEntityResponse)((Object)obj);
        return Objects.equals(this.entityType(), other.entityType()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.entityArn(), other.entityArn()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.details(), other.details());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEntityResponse").add("EntityType", (Object)this.entityType()).add("EntityIdentifier", (Object)this.entityIdentifier()).add("EntityArn", (Object)this.entityArn()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("Details", (Object)this.details()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "EntityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "EntityArn": {
                return Optional.ofNullable(clazz.cast(this.entityArn()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEntityResponse, T> g) {
        return obj -> g.apply((DescribeEntityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceCatalogResponse.BuilderImpl
    implements Builder {
        private String entityType;
        private String entityIdentifier;
        private String entityArn;
        private String lastModifiedDate;
        private String details;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEntityResponse model) {
            super(model);
            this.entityType(model.entityType);
            this.entityIdentifier(model.entityIdentifier);
            this.entityArn(model.entityArn);
            this.lastModifiedDate(model.lastModifiedDate);
            this.details(model.details);
        }

        public final String getEntityType() {
            return this.entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        public final String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        public final String getEntityArn() {
            return this.entityArn;
        }

        @Override
        public final Builder entityArn(String entityArn) {
            this.entityArn = entityArn;
            return this;
        }

        public final void setEntityArn(String entityArn) {
            this.entityArn = entityArn;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(String details) {
            this.details = details;
            return this;
        }

        public final void setDetails(String details) {
            this.details = details;
        }

        @Override
        public DescribeEntityResponse build() {
            return new DescribeEntityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEntityResponse> {
        public Builder entityType(String var1);

        public Builder entityIdentifier(String var1);

        public Builder entityArn(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder details(String var1);
    }
}

