/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.ResaleAuthorizationEntityIdFilterValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResaleAuthorizationEntityIdFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResaleAuthorizationEntityIdFilter> {
    private static final SdkField<List<String>> VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValueList").getter(ResaleAuthorizationEntityIdFilter.getter(ResaleAuthorizationEntityIdFilter::valueList)).setter(ResaleAuthorizationEntityIdFilter.setter(Builder::valueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> valueList;

    private ResaleAuthorizationEntityIdFilter(BuilderImpl builder) {
        this.valueList = builder.valueList;
    }

    public final boolean hasValueList() {
        return this.valueList != null && !(this.valueList instanceof SdkAutoConstructList);
    }

    public final List<String> valueList() {
        return this.valueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValueList() ? this.valueList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResaleAuthorizationEntityIdFilter)) {
            return false;
        }
        ResaleAuthorizationEntityIdFilter other = (ResaleAuthorizationEntityIdFilter)obj;
        return this.hasValueList() == other.hasValueList() && Objects.equals(this.valueList(), other.valueList());
    }

    public final String toString() {
        return ToString.builder((String)"ResaleAuthorizationEntityIdFilter").add("ValueList", this.hasValueList() ? this.valueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValueList": {
                return Optional.ofNullable(clazz.cast(this.valueList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResaleAuthorizationEntityIdFilter, T> g) {
        return obj -> g.apply((ResaleAuthorizationEntityIdFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> valueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResaleAuthorizationEntityIdFilter model) {
            this.valueList(model.valueList);
        }

        public final Collection<String> getValueList() {
            if (this.valueList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.valueList;
        }

        public final void setValueList(Collection<String> valueList) {
            this.valueList = ResaleAuthorizationEntityIdFilterValueListCopier.copy(valueList);
        }

        @Override
        public final Builder valueList(Collection<String> valueList) {
            this.valueList = ResaleAuthorizationEntityIdFilterValueListCopier.copy(valueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueList(String ... valueList) {
            this.valueList(Arrays.asList(valueList));
            return this;
        }

        public ResaleAuthorizationEntityIdFilter build() {
            return new ResaleAuthorizationEntityIdFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResaleAuthorizationEntityIdFilter> {
        public Builder valueList(Collection<String> var1);

        public Builder valueList(String ... var1);
    }
}

