/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplacecatalog.model.AmiProductEntityIdFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.AmiProductLastModifiedDateFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.AmiProductTitleFilter;
import software.amazon.awssdk.services.marketplacecatalog.model.AmiProductVisibilityFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AmiProductFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AmiProductFilters> {
    private static final SdkField<AmiProductEntityIdFilter> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityId").getter(AmiProductFilters.getter(AmiProductFilters::entityId)).setter(AmiProductFilters.setter(Builder::entityId)).constructor(AmiProductEntityIdFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<AmiProductLastModifiedDateFilter> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedDate").getter(AmiProductFilters.getter(AmiProductFilters::lastModifiedDate)).setter(AmiProductFilters.setter(Builder::lastModifiedDate)).constructor(AmiProductLastModifiedDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<AmiProductTitleFilter> PRODUCT_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProductTitle").getter(AmiProductFilters.getter(AmiProductFilters::productTitle)).setter(AmiProductFilters.setter(Builder::productTitle)).constructor(AmiProductTitleFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductTitle").build()}).build();
    private static final SdkField<AmiProductVisibilityFilter> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Visibility").getter(AmiProductFilters.getter(AmiProductFilters::visibility)).setter(AmiProductFilters.setter(Builder::visibility)).constructor(AmiProductVisibilityFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD, LAST_MODIFIED_DATE_FIELD, PRODUCT_TITLE_FIELD, VISIBILITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final AmiProductEntityIdFilter entityId;
    private final AmiProductLastModifiedDateFilter lastModifiedDate;
    private final AmiProductTitleFilter productTitle;
    private final AmiProductVisibilityFilter visibility;

    private AmiProductFilters(BuilderImpl builder) {
        this.entityId = builder.entityId;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.productTitle = builder.productTitle;
        this.visibility = builder.visibility;
    }

    public final AmiProductEntityIdFilter entityId() {
        return this.entityId;
    }

    public final AmiProductLastModifiedDateFilter lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final AmiProductTitleFilter productTitle() {
        return this.productTitle;
    }

    public final AmiProductVisibilityFilter visibility() {
        return this.visibility;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.productTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibility());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmiProductFilters)) {
            return false;
        }
        AmiProductFilters other = (AmiProductFilters)obj;
        return Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.productTitle(), other.productTitle()) && Objects.equals(this.visibility(), other.visibility());
    }

    public final String toString() {
        return ToString.builder((String)"AmiProductFilters").add("EntityId", (Object)this.entityId()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("ProductTitle", (Object)this.productTitle()).add("Visibility", (Object)this.visibility()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "ProductTitle": {
                return Optional.ofNullable(clazz.cast(this.productTitle()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibility()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmiProductFilters, T> g) {
        return obj -> g.apply((AmiProductFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AmiProductEntityIdFilter entityId;
        private AmiProductLastModifiedDateFilter lastModifiedDate;
        private AmiProductTitleFilter productTitle;
        private AmiProductVisibilityFilter visibility;

        private BuilderImpl() {
        }

        private BuilderImpl(AmiProductFilters model) {
            this.entityId(model.entityId);
            this.lastModifiedDate(model.lastModifiedDate);
            this.productTitle(model.productTitle);
            this.visibility(model.visibility);
        }

        public final AmiProductEntityIdFilter.Builder getEntityId() {
            return this.entityId != null ? this.entityId.toBuilder() : null;
        }

        public final void setEntityId(AmiProductEntityIdFilter.BuilderImpl entityId) {
            this.entityId = entityId != null ? entityId.build() : null;
        }

        @Override
        public final Builder entityId(AmiProductEntityIdFilter entityId) {
            this.entityId = entityId;
            return this;
        }

        public final AmiProductLastModifiedDateFilter.Builder getLastModifiedDate() {
            return this.lastModifiedDate != null ? this.lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(AmiProductLastModifiedDateFilter.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(AmiProductLastModifiedDateFilter lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final AmiProductTitleFilter.Builder getProductTitle() {
            return this.productTitle != null ? this.productTitle.toBuilder() : null;
        }

        public final void setProductTitle(AmiProductTitleFilter.BuilderImpl productTitle) {
            this.productTitle = productTitle != null ? productTitle.build() : null;
        }

        @Override
        public final Builder productTitle(AmiProductTitleFilter productTitle) {
            this.productTitle = productTitle;
            return this;
        }

        public final AmiProductVisibilityFilter.Builder getVisibility() {
            return this.visibility != null ? this.visibility.toBuilder() : null;
        }

        public final void setVisibility(AmiProductVisibilityFilter.BuilderImpl visibility) {
            this.visibility = visibility != null ? visibility.build() : null;
        }

        @Override
        public final Builder visibility(AmiProductVisibilityFilter visibility) {
            this.visibility = visibility;
            return this;
        }

        public AmiProductFilters build() {
            return new AmiProductFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AmiProductFilters> {
        public Builder entityId(AmiProductEntityIdFilter var1);

        default public Builder entityId(Consumer<AmiProductEntityIdFilter.Builder> entityId) {
            return this.entityId((AmiProductEntityIdFilter)((AmiProductEntityIdFilter.Builder)AmiProductEntityIdFilter.builder().applyMutation(entityId)).build());
        }

        public Builder lastModifiedDate(AmiProductLastModifiedDateFilter var1);

        default public Builder lastModifiedDate(Consumer<AmiProductLastModifiedDateFilter.Builder> lastModifiedDate) {
            return this.lastModifiedDate((AmiProductLastModifiedDateFilter)((AmiProductLastModifiedDateFilter.Builder)AmiProductLastModifiedDateFilter.builder().applyMutation(lastModifiedDate)).build());
        }

        public Builder productTitle(AmiProductTitleFilter var1);

        default public Builder productTitle(Consumer<AmiProductTitleFilter.Builder> productTitle) {
            return this.productTitle((AmiProductTitleFilter)((AmiProductTitleFilter.Builder)AmiProductTitleFilter.builder().applyMutation(productTitle)).build());
        }

        public Builder visibility(AmiProductVisibilityFilter var1);

        default public Builder visibility(Consumer<AmiProductVisibilityFilter.Builder> visibility) {
            return this.visibility((AmiProductVisibilityFilter)((AmiProductVisibilityFilter.Builder)AmiProductVisibilityFilter.builder().applyMutation(visibility)).build());
        }
    }
}

