/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.marketplacecatalog.model.AmiProductSort;
import software.amazon.awssdk.services.marketplacecatalog.model.ContainerProductSort;
import software.amazon.awssdk.services.marketplacecatalog.model.DataProductSort;
import software.amazon.awssdk.services.marketplacecatalog.model.OfferSort;
import software.amazon.awssdk.services.marketplacecatalog.model.ResaleAuthorizationSort;
import software.amazon.awssdk.services.marketplacecatalog.model.SaaSProductSort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityTypeSort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityTypeSort> {
    private static final SdkField<DataProductSort> DATA_PRODUCT_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataProductSort").getter(EntityTypeSort.getter(EntityTypeSort::dataProductSort)).setter(EntityTypeSort.setter(Builder::dataProductSort)).constructor(DataProductSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProductSort").build()}).build();
    private static final SdkField<SaaSProductSort> SAA_S_PRODUCT_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SaaSProductSort").getter(EntityTypeSort.getter(EntityTypeSort::saaSProductSort)).setter(EntityTypeSort.setter(Builder::saaSProductSort)).constructor(SaaSProductSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaaSProductSort").build()}).build();
    private static final SdkField<AmiProductSort> AMI_PRODUCT_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmiProductSort").getter(EntityTypeSort.getter(EntityTypeSort::amiProductSort)).setter(EntityTypeSort.setter(Builder::amiProductSort)).constructor(AmiProductSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiProductSort").build()}).build();
    private static final SdkField<OfferSort> OFFER_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OfferSort").getter(EntityTypeSort.getter(EntityTypeSort::offerSort)).setter(EntityTypeSort.setter(Builder::offerSort)).constructor(OfferSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferSort").build()}).build();
    private static final SdkField<ContainerProductSort> CONTAINER_PRODUCT_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContainerProductSort").getter(EntityTypeSort.getter(EntityTypeSort::containerProductSort)).setter(EntityTypeSort.setter(Builder::containerProductSort)).constructor(ContainerProductSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerProductSort").build()}).build();
    private static final SdkField<ResaleAuthorizationSort> RESALE_AUTHORIZATION_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResaleAuthorizationSort").getter(EntityTypeSort.getter(EntityTypeSort::resaleAuthorizationSort)).setter(EntityTypeSort.setter(Builder::resaleAuthorizationSort)).constructor(ResaleAuthorizationSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResaleAuthorizationSort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PRODUCT_SORT_FIELD, SAA_S_PRODUCT_SORT_FIELD, AMI_PRODUCT_SORT_FIELD, OFFER_SORT_FIELD, CONTAINER_PRODUCT_SORT_FIELD, RESALE_AUTHORIZATION_SORT_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataProductSort dataProductSort;
    private final SaaSProductSort saaSProductSort;
    private final AmiProductSort amiProductSort;
    private final OfferSort offerSort;
    private final ContainerProductSort containerProductSort;
    private final ResaleAuthorizationSort resaleAuthorizationSort;
    private final Type type;

    private EntityTypeSort(BuilderImpl builder) {
        this.dataProductSort = builder.dataProductSort;
        this.saaSProductSort = builder.saaSProductSort;
        this.amiProductSort = builder.amiProductSort;
        this.offerSort = builder.offerSort;
        this.containerProductSort = builder.containerProductSort;
        this.resaleAuthorizationSort = builder.resaleAuthorizationSort;
        this.type = builder.type;
    }

    public final DataProductSort dataProductSort() {
        return this.dataProductSort;
    }

    public final SaaSProductSort saaSProductSort() {
        return this.saaSProductSort;
    }

    public final AmiProductSort amiProductSort() {
        return this.amiProductSort;
    }

    public final OfferSort offerSort() {
        return this.offerSort;
    }

    public final ContainerProductSort containerProductSort() {
        return this.containerProductSort;
    }

    public final ResaleAuthorizationSort resaleAuthorizationSort() {
        return this.resaleAuthorizationSort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProductSort());
        hashCode = 31 * hashCode + Objects.hashCode(this.saaSProductSort());
        hashCode = 31 * hashCode + Objects.hashCode(this.amiProductSort());
        hashCode = 31 * hashCode + Objects.hashCode(this.offerSort());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerProductSort());
        hashCode = 31 * hashCode + Objects.hashCode(this.resaleAuthorizationSort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityTypeSort)) {
            return false;
        }
        EntityTypeSort other = (EntityTypeSort)obj;
        return Objects.equals(this.dataProductSort(), other.dataProductSort()) && Objects.equals(this.saaSProductSort(), other.saaSProductSort()) && Objects.equals(this.amiProductSort(), other.amiProductSort()) && Objects.equals(this.offerSort(), other.offerSort()) && Objects.equals(this.containerProductSort(), other.containerProductSort()) && Objects.equals(this.resaleAuthorizationSort(), other.resaleAuthorizationSort());
    }

    public final String toString() {
        return ToString.builder((String)"EntityTypeSort").add("DataProductSort", (Object)this.dataProductSort()).add("SaaSProductSort", (Object)this.saaSProductSort()).add("AmiProductSort", (Object)this.amiProductSort()).add("OfferSort", (Object)this.offerSort()).add("ContainerProductSort", (Object)this.containerProductSort()).add("ResaleAuthorizationSort", (Object)this.resaleAuthorizationSort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataProductSort": {
                return Optional.ofNullable(clazz.cast(this.dataProductSort()));
            }
            case "SaaSProductSort": {
                return Optional.ofNullable(clazz.cast(this.saaSProductSort()));
            }
            case "AmiProductSort": {
                return Optional.ofNullable(clazz.cast(this.amiProductSort()));
            }
            case "OfferSort": {
                return Optional.ofNullable(clazz.cast(this.offerSort()));
            }
            case "ContainerProductSort": {
                return Optional.ofNullable(clazz.cast(this.containerProductSort()));
            }
            case "ResaleAuthorizationSort": {
                return Optional.ofNullable(clazz.cast(this.resaleAuthorizationSort()));
            }
        }
        return Optional.empty();
    }

    public static EntityTypeSort fromDataProductSort(DataProductSort dataProductSort) {
        return (EntityTypeSort)EntityTypeSort.builder().dataProductSort(dataProductSort).build();
    }

    public static EntityTypeSort fromDataProductSort(Consumer<DataProductSort.Builder> dataProductSort) {
        DataProductSort.Builder builder = DataProductSort.builder();
        dataProductSort.accept(builder);
        return EntityTypeSort.fromDataProductSort((DataProductSort)builder.build());
    }

    public static EntityTypeSort fromSaaSProductSort(SaaSProductSort saaSProductSort) {
        return (EntityTypeSort)EntityTypeSort.builder().saaSProductSort(saaSProductSort).build();
    }

    public static EntityTypeSort fromSaaSProductSort(Consumer<SaaSProductSort.Builder> saaSProductSort) {
        SaaSProductSort.Builder builder = SaaSProductSort.builder();
        saaSProductSort.accept(builder);
        return EntityTypeSort.fromSaaSProductSort((SaaSProductSort)builder.build());
    }

    public static EntityTypeSort fromAmiProductSort(AmiProductSort amiProductSort) {
        return (EntityTypeSort)EntityTypeSort.builder().amiProductSort(amiProductSort).build();
    }

    public static EntityTypeSort fromAmiProductSort(Consumer<AmiProductSort.Builder> amiProductSort) {
        AmiProductSort.Builder builder = AmiProductSort.builder();
        amiProductSort.accept(builder);
        return EntityTypeSort.fromAmiProductSort((AmiProductSort)builder.build());
    }

    public static EntityTypeSort fromOfferSort(OfferSort offerSort) {
        return (EntityTypeSort)EntityTypeSort.builder().offerSort(offerSort).build();
    }

    public static EntityTypeSort fromOfferSort(Consumer<OfferSort.Builder> offerSort) {
        OfferSort.Builder builder = OfferSort.builder();
        offerSort.accept(builder);
        return EntityTypeSort.fromOfferSort((OfferSort)builder.build());
    }

    public static EntityTypeSort fromContainerProductSort(ContainerProductSort containerProductSort) {
        return (EntityTypeSort)EntityTypeSort.builder().containerProductSort(containerProductSort).build();
    }

    public static EntityTypeSort fromContainerProductSort(Consumer<ContainerProductSort.Builder> containerProductSort) {
        ContainerProductSort.Builder builder = ContainerProductSort.builder();
        containerProductSort.accept(builder);
        return EntityTypeSort.fromContainerProductSort((ContainerProductSort)builder.build());
    }

    public static EntityTypeSort fromResaleAuthorizationSort(ResaleAuthorizationSort resaleAuthorizationSort) {
        return (EntityTypeSort)EntityTypeSort.builder().resaleAuthorizationSort(resaleAuthorizationSort).build();
    }

    public static EntityTypeSort fromResaleAuthorizationSort(Consumer<ResaleAuthorizationSort.Builder> resaleAuthorizationSort) {
        ResaleAuthorizationSort.Builder builder = ResaleAuthorizationSort.builder();
        resaleAuthorizationSort.accept(builder);
        return EntityTypeSort.fromResaleAuthorizationSort((ResaleAuthorizationSort)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityTypeSort, T> g) {
        return obj -> g.apply((EntityTypeSort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DATA_PRODUCT_SORT,
        SAA_S_PRODUCT_SORT,
        AMI_PRODUCT_SORT,
        OFFER_SORT,
        CONTAINER_PRODUCT_SORT,
        RESALE_AUTHORIZATION_SORT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DataProductSort dataProductSort;
        private SaaSProductSort saaSProductSort;
        private AmiProductSort amiProductSort;
        private OfferSort offerSort;
        private ContainerProductSort containerProductSort;
        private ResaleAuthorizationSort resaleAuthorizationSort;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EntityTypeSort model) {
            this.dataProductSort(model.dataProductSort);
            this.saaSProductSort(model.saaSProductSort);
            this.amiProductSort(model.amiProductSort);
            this.offerSort(model.offerSort);
            this.containerProductSort(model.containerProductSort);
            this.resaleAuthorizationSort(model.resaleAuthorizationSort);
        }

        public final DataProductSort.Builder getDataProductSort() {
            return this.dataProductSort != null ? this.dataProductSort.toBuilder() : null;
        }

        public final void setDataProductSort(DataProductSort.BuilderImpl dataProductSort) {
            DataProductSort oldValue = this.dataProductSort;
            this.dataProductSort = dataProductSort != null ? dataProductSort.build() : null;
            this.handleUnionValueChange(Type.DATA_PRODUCT_SORT, oldValue, this.dataProductSort);
        }

        @Override
        public final Builder dataProductSort(DataProductSort dataProductSort) {
            DataProductSort oldValue = this.dataProductSort;
            this.dataProductSort = dataProductSort;
            this.handleUnionValueChange(Type.DATA_PRODUCT_SORT, oldValue, this.dataProductSort);
            return this;
        }

        public final SaaSProductSort.Builder getSaaSProductSort() {
            return this.saaSProductSort != null ? this.saaSProductSort.toBuilder() : null;
        }

        public final void setSaaSProductSort(SaaSProductSort.BuilderImpl saaSProductSort) {
            SaaSProductSort oldValue = this.saaSProductSort;
            this.saaSProductSort = saaSProductSort != null ? saaSProductSort.build() : null;
            this.handleUnionValueChange(Type.SAA_S_PRODUCT_SORT, oldValue, this.saaSProductSort);
        }

        @Override
        public final Builder saaSProductSort(SaaSProductSort saaSProductSort) {
            SaaSProductSort oldValue = this.saaSProductSort;
            this.saaSProductSort = saaSProductSort;
            this.handleUnionValueChange(Type.SAA_S_PRODUCT_SORT, oldValue, this.saaSProductSort);
            return this;
        }

        public final AmiProductSort.Builder getAmiProductSort() {
            return this.amiProductSort != null ? this.amiProductSort.toBuilder() : null;
        }

        public final void setAmiProductSort(AmiProductSort.BuilderImpl amiProductSort) {
            AmiProductSort oldValue = this.amiProductSort;
            this.amiProductSort = amiProductSort != null ? amiProductSort.build() : null;
            this.handleUnionValueChange(Type.AMI_PRODUCT_SORT, oldValue, this.amiProductSort);
        }

        @Override
        public final Builder amiProductSort(AmiProductSort amiProductSort) {
            AmiProductSort oldValue = this.amiProductSort;
            this.amiProductSort = amiProductSort;
            this.handleUnionValueChange(Type.AMI_PRODUCT_SORT, oldValue, this.amiProductSort);
            return this;
        }

        public final OfferSort.Builder getOfferSort() {
            return this.offerSort != null ? this.offerSort.toBuilder() : null;
        }

        public final void setOfferSort(OfferSort.BuilderImpl offerSort) {
            OfferSort oldValue = this.offerSort;
            this.offerSort = offerSort != null ? offerSort.build() : null;
            this.handleUnionValueChange(Type.OFFER_SORT, oldValue, this.offerSort);
        }

        @Override
        public final Builder offerSort(OfferSort offerSort) {
            OfferSort oldValue = this.offerSort;
            this.offerSort = offerSort;
            this.handleUnionValueChange(Type.OFFER_SORT, oldValue, this.offerSort);
            return this;
        }

        public final ContainerProductSort.Builder getContainerProductSort() {
            return this.containerProductSort != null ? this.containerProductSort.toBuilder() : null;
        }

        public final void setContainerProductSort(ContainerProductSort.BuilderImpl containerProductSort) {
            ContainerProductSort oldValue = this.containerProductSort;
            this.containerProductSort = containerProductSort != null ? containerProductSort.build() : null;
            this.handleUnionValueChange(Type.CONTAINER_PRODUCT_SORT, oldValue, this.containerProductSort);
        }

        @Override
        public final Builder containerProductSort(ContainerProductSort containerProductSort) {
            ContainerProductSort oldValue = this.containerProductSort;
            this.containerProductSort = containerProductSort;
            this.handleUnionValueChange(Type.CONTAINER_PRODUCT_SORT, oldValue, this.containerProductSort);
            return this;
        }

        public final ResaleAuthorizationSort.Builder getResaleAuthorizationSort() {
            return this.resaleAuthorizationSort != null ? this.resaleAuthorizationSort.toBuilder() : null;
        }

        public final void setResaleAuthorizationSort(ResaleAuthorizationSort.BuilderImpl resaleAuthorizationSort) {
            ResaleAuthorizationSort oldValue = this.resaleAuthorizationSort;
            this.resaleAuthorizationSort = resaleAuthorizationSort != null ? resaleAuthorizationSort.build() : null;
            this.handleUnionValueChange(Type.RESALE_AUTHORIZATION_SORT, oldValue, this.resaleAuthorizationSort);
        }

        @Override
        public final Builder resaleAuthorizationSort(ResaleAuthorizationSort resaleAuthorizationSort) {
            ResaleAuthorizationSort oldValue = this.resaleAuthorizationSort;
            this.resaleAuthorizationSort = resaleAuthorizationSort;
            this.handleUnionValueChange(Type.RESALE_AUTHORIZATION_SORT, oldValue, this.resaleAuthorizationSort);
            return this;
        }

        public EntityTypeSort build() {
            return new EntityTypeSort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityTypeSort> {
        public Builder dataProductSort(DataProductSort var1);

        default public Builder dataProductSort(Consumer<DataProductSort.Builder> dataProductSort) {
            return this.dataProductSort((DataProductSort)((DataProductSort.Builder)DataProductSort.builder().applyMutation(dataProductSort)).build());
        }

        public Builder saaSProductSort(SaaSProductSort var1);

        default public Builder saaSProductSort(Consumer<SaaSProductSort.Builder> saaSProductSort) {
            return this.saaSProductSort((SaaSProductSort)((SaaSProductSort.Builder)SaaSProductSort.builder().applyMutation(saaSProductSort)).build());
        }

        public Builder amiProductSort(AmiProductSort var1);

        default public Builder amiProductSort(Consumer<AmiProductSort.Builder> amiProductSort) {
            return this.amiProductSort((AmiProductSort)((AmiProductSort.Builder)AmiProductSort.builder().applyMutation(amiProductSort)).build());
        }

        public Builder offerSort(OfferSort var1);

        default public Builder offerSort(Consumer<OfferSort.Builder> offerSort) {
            return this.offerSort((OfferSort)((OfferSort.Builder)OfferSort.builder().applyMutation(offerSort)).build());
        }

        public Builder containerProductSort(ContainerProductSort var1);

        default public Builder containerProductSort(Consumer<ContainerProductSort.Builder> containerProductSort) {
            return this.containerProductSort((ContainerProductSort)((ContainerProductSort.Builder)ContainerProductSort.builder().applyMutation(containerProductSort)).build());
        }

        public Builder resaleAuthorizationSort(ResaleAuthorizationSort var1);

        default public Builder resaleAuthorizationSort(Consumer<ResaleAuthorizationSort.Builder> resaleAuthorizationSort) {
            return this.resaleAuthorizationSort((ResaleAuthorizationSort)((ResaleAuthorizationSort.Builder)ResaleAuthorizationSort.builder().applyMutation(resaleAuthorizationSort)).build());
        }
    }
}

