/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplacecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplacecatalog.model.ChangeSetDescriptionCopier;
import software.amazon.awssdk.services.marketplacecatalog.model.ChangeStatus;
import software.amazon.awssdk.services.marketplacecatalog.model.ChangeSummary;
import software.amazon.awssdk.services.marketplacecatalog.model.FailureCode;
import software.amazon.awssdk.services.marketplacecatalog.model.Intent;
import software.amazon.awssdk.services.marketplacecatalog.model.MarketplaceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeChangeSetResponse
extends MarketplaceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeChangeSetResponse> {
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetId").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::changeSetId)).setter(DescribeChangeSetResponse.setter(Builder::changeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()}).build();
    private static final SdkField<String> CHANGE_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetArn").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::changeSetArn)).setter(DescribeChangeSetResponse.setter(Builder::changeSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetArn").build()}).build();
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetName").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::changeSetName)).setter(DescribeChangeSetResponse.setter(Builder::changeSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()}).build();
    private static final SdkField<String> INTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Intent").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::intentAsString)).setter(DescribeChangeSetResponse.setter(Builder::intent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intent").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::startTime)).setter(DescribeChangeSetResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndTime").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::endTime)).setter(DescribeChangeSetResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::statusAsString)).setter(DescribeChangeSetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureCode").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::failureCodeAsString)).setter(DescribeChangeSetResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()}).build();
    private static final SdkField<String> FAILURE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureDescription").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::failureDescription)).setter(DescribeChangeSetResponse.setter(Builder::failureDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDescription").build()}).build();
    private static final SdkField<List<ChangeSummary>> CHANGE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChangeSet").getter(DescribeChangeSetResponse.getter(DescribeChangeSetResponse::changeSet)).setter(DescribeChangeSetResponse.setter(Builder::changeSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_SET_ID_FIELD, CHANGE_SET_ARN_FIELD, CHANGE_SET_NAME_FIELD, INTENT_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD, FAILURE_CODE_FIELD, FAILURE_DESCRIPTION_FIELD, CHANGE_SET_FIELD));
    private final String changeSetId;
    private final String changeSetArn;
    private final String changeSetName;
    private final String intent;
    private final String startTime;
    private final String endTime;
    private final String status;
    private final String failureCode;
    private final String failureDescription;
    private final List<ChangeSummary> changeSet;

    private DescribeChangeSetResponse(BuilderImpl builder) {
        super(builder);
        this.changeSetId = builder.changeSetId;
        this.changeSetArn = builder.changeSetArn;
        this.changeSetName = builder.changeSetName;
        this.intent = builder.intent;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
        this.failureCode = builder.failureCode;
        this.failureDescription = builder.failureDescription;
        this.changeSet = builder.changeSet;
    }

    public final String changeSetId() {
        return this.changeSetId;
    }

    public final String changeSetArn() {
        return this.changeSetArn;
    }

    public final String changeSetName() {
        return this.changeSetName;
    }

    public final Intent intent() {
        return Intent.fromValue(this.intent);
    }

    public final String intentAsString() {
        return this.intent;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String endTime() {
        return this.endTime;
    }

    public final ChangeStatus status() {
        return ChangeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final FailureCode failureCode() {
        return FailureCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final String failureDescription() {
        return this.failureDescription;
    }

    public final boolean hasChangeSet() {
        return this.changeSet != null && !(this.changeSet instanceof SdkAutoConstructList);
    }

    public final List<ChangeSummary> changeSet() {
        return this.changeSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeSet() ? this.changeSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetResponse)) {
            return false;
        }
        DescribeChangeSetResponse other = (DescribeChangeSetResponse)((Object)obj);
        return Objects.equals(this.changeSetId(), other.changeSetId()) && Objects.equals(this.changeSetArn(), other.changeSetArn()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.intentAsString(), other.intentAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.failureDescription(), other.failureDescription()) && this.hasChangeSet() == other.hasChangeSet() && Objects.equals(this.changeSet(), other.changeSet());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeChangeSetResponse").add("ChangeSetId", (Object)this.changeSetId()).add("ChangeSetArn", (Object)this.changeSetArn()).add("ChangeSetName", (Object)this.changeSetName()).add("Intent", (Object)this.intentAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.statusAsString()).add("FailureCode", (Object)this.failureCodeAsString()).add("FailureDescription", (Object)this.failureDescription()).add("ChangeSet", this.hasChangeSet() ? this.changeSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.changeSetId()));
            }
            case "ChangeSetArn": {
                return Optional.ofNullable(clazz.cast(this.changeSetArn()));
            }
            case "ChangeSetName": {
                return Optional.ofNullable(clazz.cast(this.changeSetName()));
            }
            case "Intent": {
                return Optional.ofNullable(clazz.cast(this.intentAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "FailureDescription": {
                return Optional.ofNullable(clazz.cast(this.failureDescription()));
            }
            case "ChangeSet": {
                return Optional.ofNullable(clazz.cast(this.changeSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChangeSetResponse, T> g) {
        return obj -> g.apply((DescribeChangeSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MarketplaceCatalogResponse.BuilderImpl
    implements Builder {
        private String changeSetId;
        private String changeSetArn;
        private String changeSetName;
        private String intent;
        private String startTime;
        private String endTime;
        private String status;
        private String failureCode;
        private String failureDescription;
        private List<ChangeSummary> changeSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetResponse model) {
            super(model);
            this.changeSetId(model.changeSetId);
            this.changeSetArn(model.changeSetArn);
            this.changeSetName(model.changeSetName);
            this.intent(model.intent);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
            this.failureCode(model.failureCode);
            this.failureDescription(model.failureDescription);
            this.changeSet(model.changeSet);
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getChangeSetArn() {
            return this.changeSetArn;
        }

        public final void setChangeSetArn(String changeSetArn) {
            this.changeSetArn = changeSetArn;
        }

        @Override
        public final Builder changeSetArn(String changeSetArn) {
            this.changeSetArn = changeSetArn;
            return this;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getIntent() {
            return this.intent;
        }

        public final void setIntent(String intent) {
            this.intent = intent;
        }

        @Override
        public final Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        @Override
        public final Builder intent(Intent intent) {
            this.intent(intent == null ? null : intent.toString());
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(FailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getFailureDescription() {
            return this.failureDescription;
        }

        public final void setFailureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
        }

        @Override
        public final Builder failureDescription(String failureDescription) {
            this.failureDescription = failureDescription;
            return this;
        }

        public final List<ChangeSummary.Builder> getChangeSet() {
            List<ChangeSummary.Builder> result = ChangeSetDescriptionCopier.copyToBuilder(this.changeSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeSet(Collection<ChangeSummary.BuilderImpl> changeSet) {
            this.changeSet = ChangeSetDescriptionCopier.copyFromBuilder(changeSet);
        }

        @Override
        public final Builder changeSet(Collection<ChangeSummary> changeSet) {
            this.changeSet = ChangeSetDescriptionCopier.copy(changeSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSet(ChangeSummary ... changeSet) {
            this.changeSet(Arrays.asList(changeSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeSet(Consumer<ChangeSummary.Builder> ... changeSet) {
            this.changeSet(Stream.of(changeSet).map(c -> (ChangeSummary)((ChangeSummary.Builder)ChangeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeChangeSetResponse build() {
            return new DescribeChangeSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MarketplaceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeChangeSetResponse> {
        public Builder changeSetId(String var1);

        public Builder changeSetArn(String var1);

        public Builder changeSetName(String var1);

        public Builder intent(String var1);

        public Builder intent(Intent var1);

        public Builder startTime(String var1);

        public Builder endTime(String var1);

        public Builder status(String var1);

        public Builder status(ChangeStatus var1);

        public Builder failureCode(String var1);

        public Builder failureCode(FailureCode var1);

        public Builder failureDescription(String var1);

        public Builder changeSet(Collection<ChangeSummary> var1);

        public Builder changeSet(ChangeSummary ... var1);

        public Builder changeSet(Consumer<ChangeSummary.Builder> ... var1);
    }
}

