/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AudioChannelTaggingSettings;
import software.amazon.awssdk.services.mediaconvert.model.AudioCodecSettings;
import software.amazon.awssdk.services.mediaconvert.model.AudioLanguageCodeControl;
import software.amazon.awssdk.services.mediaconvert.model.AudioNormalizationSettings;
import software.amazon.awssdk.services.mediaconvert.model.AudioTypeControl;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.services.mediaconvert.model.RemixSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioDescription> {
    private static final SdkField<AudioChannelTaggingSettings> AUDIO_CHANNEL_TAGGING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioChannelTaggingSettings").getter(AudioDescription.getter(AudioDescription::audioChannelTaggingSettings)).setter(AudioDescription.setter(Builder::audioChannelTaggingSettings)).constructor(AudioChannelTaggingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioChannelTaggingSettings").build()}).build();
    private static final SdkField<AudioNormalizationSettings> AUDIO_NORMALIZATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AudioNormalizationSettings").getter(AudioDescription.getter(AudioDescription::audioNormalizationSettings)).setter(AudioDescription.setter(Builder::audioNormalizationSettings)).constructor(AudioNormalizationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioNormalizationSettings").build()}).build();
    private static final SdkField<String> AUDIO_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioSourceName").getter(AudioDescription.getter(AudioDescription::audioSourceName)).setter(AudioDescription.setter(Builder::audioSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSourceName").build()}).build();
    private static final SdkField<Integer> AUDIO_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AudioType").getter(AudioDescription.getter(AudioDescription::audioType)).setter(AudioDescription.setter(Builder::audioType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioType").build()}).build();
    private static final SdkField<String> AUDIO_TYPE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioTypeControl").getter(AudioDescription.getter(AudioDescription::audioTypeControlAsString)).setter(AudioDescription.setter(Builder::audioTypeControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTypeControl").build()}).build();
    private static final SdkField<AudioCodecSettings> CODEC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodecSettings").getter(AudioDescription.getter(AudioDescription::codecSettings)).setter(AudioDescription.setter(Builder::codecSettings)).constructor(AudioCodecSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSettings").build()}).build();
    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomLanguageCode").getter(AudioDescription.getter(AudioDescription::customLanguageCode)).setter(AudioDescription.setter(Builder::customLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(AudioDescription.getter(AudioDescription::languageCodeAsString)).setter(AudioDescription.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCodeControl").getter(AudioDescription.getter(AudioDescription::languageCodeControlAsString)).setter(AudioDescription.setter(Builder::languageCodeControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCodeControl").build()}).build();
    private static final SdkField<RemixSettings> REMIX_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemixSettings").getter(AudioDescription.getter(AudioDescription::remixSettings)).setter(AudioDescription.setter(Builder::remixSettings)).constructor(RemixSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remixSettings").build()}).build();
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(AudioDescription.getter(AudioDescription::streamName)).setter(AudioDescription.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_CHANNEL_TAGGING_SETTINGS_FIELD, AUDIO_NORMALIZATION_SETTINGS_FIELD, AUDIO_SOURCE_NAME_FIELD, AUDIO_TYPE_FIELD, AUDIO_TYPE_CONTROL_FIELD, CODEC_SETTINGS_FIELD, CUSTOM_LANGUAGE_CODE_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_CODE_CONTROL_FIELD, REMIX_SETTINGS_FIELD, STREAM_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("audioChannelTaggingSettings", AUDIO_CHANNEL_TAGGING_SETTINGS_FIELD);
            this.put("audioNormalizationSettings", AUDIO_NORMALIZATION_SETTINGS_FIELD);
            this.put("audioSourceName", AUDIO_SOURCE_NAME_FIELD);
            this.put("audioType", AUDIO_TYPE_FIELD);
            this.put("audioTypeControl", AUDIO_TYPE_CONTROL_FIELD);
            this.put("codecSettings", CODEC_SETTINGS_FIELD);
            this.put("customLanguageCode", CUSTOM_LANGUAGE_CODE_FIELD);
            this.put("languageCode", LANGUAGE_CODE_FIELD);
            this.put("languageCodeControl", LANGUAGE_CODE_CONTROL_FIELD);
            this.put("remixSettings", REMIX_SETTINGS_FIELD);
            this.put("streamName", STREAM_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AudioChannelTaggingSettings audioChannelTaggingSettings;
    private final AudioNormalizationSettings audioNormalizationSettings;
    private final String audioSourceName;
    private final Integer audioType;
    private final String audioTypeControl;
    private final AudioCodecSettings codecSettings;
    private final String customLanguageCode;
    private final String languageCode;
    private final String languageCodeControl;
    private final RemixSettings remixSettings;
    private final String streamName;

    private AudioDescription(BuilderImpl builder) {
        this.audioChannelTaggingSettings = builder.audioChannelTaggingSettings;
        this.audioNormalizationSettings = builder.audioNormalizationSettings;
        this.audioSourceName = builder.audioSourceName;
        this.audioType = builder.audioType;
        this.audioTypeControl = builder.audioTypeControl;
        this.codecSettings = builder.codecSettings;
        this.customLanguageCode = builder.customLanguageCode;
        this.languageCode = builder.languageCode;
        this.languageCodeControl = builder.languageCodeControl;
        this.remixSettings = builder.remixSettings;
        this.streamName = builder.streamName;
    }

    public final AudioChannelTaggingSettings audioChannelTaggingSettings() {
        return this.audioChannelTaggingSettings;
    }

    public final AudioNormalizationSettings audioNormalizationSettings() {
        return this.audioNormalizationSettings;
    }

    public final String audioSourceName() {
        return this.audioSourceName;
    }

    public final Integer audioType() {
        return this.audioType;
    }

    public final AudioTypeControl audioTypeControl() {
        return AudioTypeControl.fromValue(this.audioTypeControl);
    }

    public final String audioTypeControlAsString() {
        return this.audioTypeControl;
    }

    public final AudioCodecSettings codecSettings() {
        return this.codecSettings;
    }

    public final String customLanguageCode() {
        return this.customLanguageCode;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final AudioLanguageCodeControl languageCodeControl() {
        return AudioLanguageCodeControl.fromValue(this.languageCodeControl);
    }

    public final String languageCodeControlAsString() {
        return this.languageCodeControl;
    }

    public final RemixSettings remixSettings() {
        return this.remixSettings;
    }

    public final String streamName() {
        return this.streamName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioChannelTaggingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioNormalizationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioType());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTypeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.remixSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioDescription)) {
            return false;
        }
        AudioDescription other = (AudioDescription)obj;
        return Objects.equals(this.audioChannelTaggingSettings(), other.audioChannelTaggingSettings()) && Objects.equals(this.audioNormalizationSettings(), other.audioNormalizationSettings()) && Objects.equals(this.audioSourceName(), other.audioSourceName()) && Objects.equals(this.audioType(), other.audioType()) && Objects.equals(this.audioTypeControlAsString(), other.audioTypeControlAsString()) && Objects.equals(this.codecSettings(), other.codecSettings()) && Objects.equals(this.customLanguageCode(), other.customLanguageCode()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.languageCodeControlAsString(), other.languageCodeControlAsString()) && Objects.equals(this.remixSettings(), other.remixSettings()) && Objects.equals(this.streamName(), other.streamName());
    }

    public final String toString() {
        return ToString.builder((String)"AudioDescription").add("AudioChannelTaggingSettings", (Object)this.audioChannelTaggingSettings()).add("AudioNormalizationSettings", (Object)this.audioNormalizationSettings()).add("AudioSourceName", (Object)this.audioSourceName()).add("AudioType", (Object)this.audioType()).add("AudioTypeControl", (Object)this.audioTypeControlAsString()).add("CodecSettings", (Object)this.codecSettings()).add("CustomLanguageCode", (Object)this.customLanguageCode()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LanguageCodeControl", (Object)this.languageCodeControlAsString()).add("RemixSettings", (Object)this.remixSettings()).add("StreamName", (Object)this.streamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioChannelTaggingSettings": {
                return Optional.ofNullable(clazz.cast(this.audioChannelTaggingSettings()));
            }
            case "AudioNormalizationSettings": {
                return Optional.ofNullable(clazz.cast(this.audioNormalizationSettings()));
            }
            case "AudioSourceName": {
                return Optional.ofNullable(clazz.cast(this.audioSourceName()));
            }
            case "AudioType": {
                return Optional.ofNullable(clazz.cast(this.audioType()));
            }
            case "AudioTypeControl": {
                return Optional.ofNullable(clazz.cast(this.audioTypeControlAsString()));
            }
            case "CodecSettings": {
                return Optional.ofNullable(clazz.cast(this.codecSettings()));
            }
            case "CustomLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.customLanguageCode()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LanguageCodeControl": {
                return Optional.ofNullable(clazz.cast(this.languageCodeControlAsString()));
            }
            case "RemixSettings": {
                return Optional.ofNullable(clazz.cast(this.remixSettings()));
            }
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AudioDescription, T> g) {
        return obj -> g.apply((AudioDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioChannelTaggingSettings audioChannelTaggingSettings;
        private AudioNormalizationSettings audioNormalizationSettings;
        private String audioSourceName;
        private Integer audioType;
        private String audioTypeControl;
        private AudioCodecSettings codecSettings;
        private String customLanguageCode;
        private String languageCode;
        private String languageCodeControl;
        private RemixSettings remixSettings;
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioDescription model) {
            this.audioChannelTaggingSettings(model.audioChannelTaggingSettings);
            this.audioNormalizationSettings(model.audioNormalizationSettings);
            this.audioSourceName(model.audioSourceName);
            this.audioType(model.audioType);
            this.audioTypeControl(model.audioTypeControl);
            this.codecSettings(model.codecSettings);
            this.customLanguageCode(model.customLanguageCode);
            this.languageCode(model.languageCode);
            this.languageCodeControl(model.languageCodeControl);
            this.remixSettings(model.remixSettings);
            this.streamName(model.streamName);
        }

        public final AudioChannelTaggingSettings.Builder getAudioChannelTaggingSettings() {
            return this.audioChannelTaggingSettings != null ? this.audioChannelTaggingSettings.toBuilder() : null;
        }

        public final void setAudioChannelTaggingSettings(AudioChannelTaggingSettings.BuilderImpl audioChannelTaggingSettings) {
            this.audioChannelTaggingSettings = audioChannelTaggingSettings != null ? audioChannelTaggingSettings.build() : null;
        }

        @Override
        public final Builder audioChannelTaggingSettings(AudioChannelTaggingSettings audioChannelTaggingSettings) {
            this.audioChannelTaggingSettings = audioChannelTaggingSettings;
            return this;
        }

        public final AudioNormalizationSettings.Builder getAudioNormalizationSettings() {
            return this.audioNormalizationSettings != null ? this.audioNormalizationSettings.toBuilder() : null;
        }

        public final void setAudioNormalizationSettings(AudioNormalizationSettings.BuilderImpl audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings != null ? audioNormalizationSettings.build() : null;
        }

        @Override
        public final Builder audioNormalizationSettings(AudioNormalizationSettings audioNormalizationSettings) {
            this.audioNormalizationSettings = audioNormalizationSettings;
            return this;
        }

        public final String getAudioSourceName() {
            return this.audioSourceName;
        }

        public final void setAudioSourceName(String audioSourceName) {
            this.audioSourceName = audioSourceName;
        }

        @Override
        public final Builder audioSourceName(String audioSourceName) {
            this.audioSourceName = audioSourceName;
            return this;
        }

        public final Integer getAudioType() {
            return this.audioType;
        }

        public final void setAudioType(Integer audioType) {
            this.audioType = audioType;
        }

        @Override
        public final Builder audioType(Integer audioType) {
            this.audioType = audioType;
            return this;
        }

        public final String getAudioTypeControl() {
            return this.audioTypeControl;
        }

        public final void setAudioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
        }

        @Override
        public final Builder audioTypeControl(String audioTypeControl) {
            this.audioTypeControl = audioTypeControl;
            return this;
        }

        @Override
        public final Builder audioTypeControl(AudioTypeControl audioTypeControl) {
            this.audioTypeControl(audioTypeControl == null ? null : audioTypeControl.toString());
            return this;
        }

        public final AudioCodecSettings.Builder getCodecSettings() {
            return this.codecSettings != null ? this.codecSettings.toBuilder() : null;
        }

        public final void setCodecSettings(AudioCodecSettings.BuilderImpl codecSettings) {
            this.codecSettings = codecSettings != null ? codecSettings.build() : null;
        }

        @Override
        public final Builder codecSettings(AudioCodecSettings codecSettings) {
            this.codecSettings = codecSettings;
            return this;
        }

        public final String getCustomLanguageCode() {
            return this.customLanguageCode;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getLanguageCodeControl() {
            return this.languageCodeControl;
        }

        public final void setLanguageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
        }

        @Override
        public final Builder languageCodeControl(String languageCodeControl) {
            this.languageCodeControl = languageCodeControl;
            return this;
        }

        @Override
        public final Builder languageCodeControl(AudioLanguageCodeControl languageCodeControl) {
            this.languageCodeControl(languageCodeControl == null ? null : languageCodeControl.toString());
            return this;
        }

        public final RemixSettings.Builder getRemixSettings() {
            return this.remixSettings != null ? this.remixSettings.toBuilder() : null;
        }

        public final void setRemixSettings(RemixSettings.BuilderImpl remixSettings) {
            this.remixSettings = remixSettings != null ? remixSettings.build() : null;
        }

        @Override
        public final Builder remixSettings(RemixSettings remixSettings) {
            this.remixSettings = remixSettings;
            return this;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public AudioDescription build() {
            return new AudioDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioDescription> {
        public Builder audioChannelTaggingSettings(AudioChannelTaggingSettings var1);

        default public Builder audioChannelTaggingSettings(Consumer<AudioChannelTaggingSettings.Builder> audioChannelTaggingSettings) {
            return this.audioChannelTaggingSettings((AudioChannelTaggingSettings)((AudioChannelTaggingSettings.Builder)AudioChannelTaggingSettings.builder().applyMutation(audioChannelTaggingSettings)).build());
        }

        public Builder audioNormalizationSettings(AudioNormalizationSettings var1);

        default public Builder audioNormalizationSettings(Consumer<AudioNormalizationSettings.Builder> audioNormalizationSettings) {
            return this.audioNormalizationSettings((AudioNormalizationSettings)((AudioNormalizationSettings.Builder)AudioNormalizationSettings.builder().applyMutation(audioNormalizationSettings)).build());
        }

        public Builder audioSourceName(String var1);

        public Builder audioType(Integer var1);

        public Builder audioTypeControl(String var1);

        public Builder audioTypeControl(AudioTypeControl var1);

        public Builder codecSettings(AudioCodecSettings var1);

        default public Builder codecSettings(Consumer<AudioCodecSettings.Builder> codecSettings) {
            return this.codecSettings((AudioCodecSettings)((AudioCodecSettings.Builder)AudioCodecSettings.builder().applyMutation(codecSettings)).build());
        }

        public Builder customLanguageCode(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder languageCodeControl(String var1);

        public Builder languageCodeControl(AudioLanguageCodeControl var1);

        public Builder remixSettings(RemixSettings var1);

        default public Builder remixSettings(Consumer<RemixSettings.Builder> remixSettings) {
            return this.remixSettings((RemixSettings)((RemixSettings.Builder)RemixSettings.builder().applyMutation(remixSettings)).build());
        }

        public Builder streamName(String var1);
    }
}

