/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaPackageOutputDestinationSettings;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramChannelDestinationSettings;
import software.amazon.awssdk.services.medialive.model.OutputDestinationSettings;
import software.amazon.awssdk.services.medialive.model.SrtOutputDestinationSettings;
import software.amazon.awssdk.services.medialive.model.___listOfMediaPackageOutputDestinationSettingsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfOutputDestinationSettingsCopier;
import software.amazon.awssdk.services.medialive.model.___listOfSrtOutputDestinationSettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputDestination> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(OutputDestination.getter(OutputDestination::id)).setter(OutputDestination.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<MediaPackageOutputDestinationSettings>> MEDIA_PACKAGE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaPackageSettings").getter(OutputDestination.getter(OutputDestination::mediaPackageSettings)).setter(OutputDestination.setter(Builder::mediaPackageSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaPackageSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaPackageOutputDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MultiplexProgramChannelDestinationSettings> MULTIPLEX_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MultiplexSettings").getter(OutputDestination.getter(OutputDestination::multiplexSettings)).setter(OutputDestination.setter(Builder::multiplexSettings)).constructor(MultiplexProgramChannelDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexSettings").build()}).build();
    private static final SdkField<List<OutputDestinationSettings>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Settings").getter(OutputDestination.getter(OutputDestination::settings)).setter(OutputDestination.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SrtOutputDestinationSettings>> SRT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SrtSettings").getter(OutputDestination.getter(OutputDestination::srtSettings)).setter(OutputDestination.setter(Builder::srtSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SrtOutputDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MEDIA_PACKAGE_SETTINGS_FIELD, MULTIPLEX_SETTINGS_FIELD, SETTINGS_FIELD, SRT_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<MediaPackageOutputDestinationSettings> mediaPackageSettings;
    private final MultiplexProgramChannelDestinationSettings multiplexSettings;
    private final List<OutputDestinationSettings> settings;
    private final List<SrtOutputDestinationSettings> srtSettings;

    private OutputDestination(BuilderImpl builder) {
        this.id = builder.id;
        this.mediaPackageSettings = builder.mediaPackageSettings;
        this.multiplexSettings = builder.multiplexSettings;
        this.settings = builder.settings;
        this.srtSettings = builder.srtSettings;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasMediaPackageSettings() {
        return this.mediaPackageSettings != null && !(this.mediaPackageSettings instanceof SdkAutoConstructList);
    }

    public final List<MediaPackageOutputDestinationSettings> mediaPackageSettings() {
        return this.mediaPackageSettings;
    }

    public final MultiplexProgramChannelDestinationSettings multiplexSettings() {
        return this.multiplexSettings;
    }

    public final boolean hasSettings() {
        return this.settings != null && !(this.settings instanceof SdkAutoConstructList);
    }

    public final List<OutputDestinationSettings> settings() {
        return this.settings;
    }

    public final boolean hasSrtSettings() {
        return this.srtSettings != null && !(this.srtSettings instanceof SdkAutoConstructList);
    }

    public final List<SrtOutputDestinationSettings> srtSettings() {
        return this.srtSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaPackageSettings() ? this.mediaPackageSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiplexSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSettings() ? this.settings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSrtSettings() ? this.srtSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDestination)) {
            return false;
        }
        OutputDestination other = (OutputDestination)obj;
        return Objects.equals(this.id(), other.id()) && this.hasMediaPackageSettings() == other.hasMediaPackageSettings() && Objects.equals(this.mediaPackageSettings(), other.mediaPackageSettings()) && Objects.equals(this.multiplexSettings(), other.multiplexSettings()) && this.hasSettings() == other.hasSettings() && Objects.equals(this.settings(), other.settings()) && this.hasSrtSettings() == other.hasSrtSettings() && Objects.equals(this.srtSettings(), other.srtSettings());
    }

    public final String toString() {
        return ToString.builder((String)"OutputDestination").add("Id", (Object)this.id()).add("MediaPackageSettings", this.hasMediaPackageSettings() ? this.mediaPackageSettings() : null).add("MultiplexSettings", (Object)this.multiplexSettings()).add("Settings", this.hasSettings() ? this.settings() : null).add("SrtSettings", this.hasSrtSettings() ? this.srtSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MediaPackageSettings": {
                return Optional.ofNullable(clazz.cast(this.mediaPackageSettings()));
            }
            case "MultiplexSettings": {
                return Optional.ofNullable(clazz.cast(this.multiplexSettings()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "SrtSettings": {
                return Optional.ofNullable(clazz.cast(this.srtSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputDestination, T> g) {
        return obj -> g.apply((OutputDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<MediaPackageOutputDestinationSettings> mediaPackageSettings = DefaultSdkAutoConstructList.getInstance();
        private MultiplexProgramChannelDestinationSettings multiplexSettings;
        private List<OutputDestinationSettings> settings = DefaultSdkAutoConstructList.getInstance();
        private List<SrtOutputDestinationSettings> srtSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDestination model) {
            this.id(model.id);
            this.mediaPackageSettings(model.mediaPackageSettings);
            this.multiplexSettings(model.multiplexSettings);
            this.settings(model.settings);
            this.srtSettings(model.srtSettings);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<MediaPackageOutputDestinationSettings.Builder> getMediaPackageSettings() {
            List<MediaPackageOutputDestinationSettings.Builder> result = ___listOfMediaPackageOutputDestinationSettingsCopier.copyToBuilder(this.mediaPackageSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaPackageSettings(Collection<MediaPackageOutputDestinationSettings.BuilderImpl> mediaPackageSettings) {
            this.mediaPackageSettings = ___listOfMediaPackageOutputDestinationSettingsCopier.copyFromBuilder(mediaPackageSettings);
        }

        @Override
        public final Builder mediaPackageSettings(Collection<MediaPackageOutputDestinationSettings> mediaPackageSettings) {
            this.mediaPackageSettings = ___listOfMediaPackageOutputDestinationSettingsCopier.copy(mediaPackageSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPackageSettings(MediaPackageOutputDestinationSettings ... mediaPackageSettings) {
            this.mediaPackageSettings(Arrays.asList(mediaPackageSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaPackageSettings(Consumer<MediaPackageOutputDestinationSettings.Builder> ... mediaPackageSettings) {
            this.mediaPackageSettings(Stream.of(mediaPackageSettings).map(c -> (MediaPackageOutputDestinationSettings)((MediaPackageOutputDestinationSettings.Builder)MediaPackageOutputDestinationSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MultiplexProgramChannelDestinationSettings.Builder getMultiplexSettings() {
            return this.multiplexSettings != null ? this.multiplexSettings.toBuilder() : null;
        }

        public final void setMultiplexSettings(MultiplexProgramChannelDestinationSettings.BuilderImpl multiplexSettings) {
            this.multiplexSettings = multiplexSettings != null ? multiplexSettings.build() : null;
        }

        @Override
        public final Builder multiplexSettings(MultiplexProgramChannelDestinationSettings multiplexSettings) {
            this.multiplexSettings = multiplexSettings;
            return this;
        }

        public final List<OutputDestinationSettings.Builder> getSettings() {
            List<OutputDestinationSettings.Builder> result = ___listOfOutputDestinationSettingsCopier.copyToBuilder(this.settings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettings(Collection<OutputDestinationSettings.BuilderImpl> settings) {
            this.settings = ___listOfOutputDestinationSettingsCopier.copyFromBuilder(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<OutputDestinationSettings> settings) {
            this.settings = ___listOfOutputDestinationSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(OutputDestinationSettings ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(Consumer<OutputDestinationSettings.Builder> ... settings) {
            this.settings(Stream.of(settings).map(c -> (OutputDestinationSettings)((OutputDestinationSettings.Builder)OutputDestinationSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SrtOutputDestinationSettings.Builder> getSrtSettings() {
            List<SrtOutputDestinationSettings.Builder> result = ___listOfSrtOutputDestinationSettingsCopier.copyToBuilder(this.srtSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSrtSettings(Collection<SrtOutputDestinationSettings.BuilderImpl> srtSettings) {
            this.srtSettings = ___listOfSrtOutputDestinationSettingsCopier.copyFromBuilder(srtSettings);
        }

        @Override
        public final Builder srtSettings(Collection<SrtOutputDestinationSettings> srtSettings) {
            this.srtSettings = ___listOfSrtOutputDestinationSettingsCopier.copy(srtSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder srtSettings(SrtOutputDestinationSettings ... srtSettings) {
            this.srtSettings(Arrays.asList(srtSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder srtSettings(Consumer<SrtOutputDestinationSettings.Builder> ... srtSettings) {
            this.srtSettings(Stream.of(srtSettings).map(c -> (SrtOutputDestinationSettings)((SrtOutputDestinationSettings.Builder)SrtOutputDestinationSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public OutputDestination build() {
            return new OutputDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputDestination> {
        public Builder id(String var1);

        public Builder mediaPackageSettings(Collection<MediaPackageOutputDestinationSettings> var1);

        public Builder mediaPackageSettings(MediaPackageOutputDestinationSettings ... var1);

        public Builder mediaPackageSettings(Consumer<MediaPackageOutputDestinationSettings.Builder> ... var1);

        public Builder multiplexSettings(MultiplexProgramChannelDestinationSettings var1);

        default public Builder multiplexSettings(Consumer<MultiplexProgramChannelDestinationSettings.Builder> multiplexSettings) {
            return this.multiplexSettings((MultiplexProgramChannelDestinationSettings)((MultiplexProgramChannelDestinationSettings.Builder)MultiplexProgramChannelDestinationSettings.builder().applyMutation(multiplexSettings)).build());
        }

        public Builder settings(Collection<OutputDestinationSettings> var1);

        public Builder settings(OutputDestinationSettings ... var1);

        public Builder settings(Consumer<OutputDestinationSettings.Builder> ... var1);

        public Builder srtSettings(Collection<SrtOutputDestinationSettings> var1);

        public Builder srtSettings(SrtOutputDestinationSettings ... var1);

        public Builder srtSettings(Consumer<SrtOutputDestinationSettings.Builder> ... var1);
    }
}

