/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MulticastSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MulticastSource> {
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceIp").getter(MulticastSource.getter(MulticastSource::sourceIp)).setter(MulticastSource.setter(Builder::sourceIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIp").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(MulticastSource.getter(MulticastSource::url)).setter(MulticastSource.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceIp;
    private final String url;

    private MulticastSource(BuilderImpl builder) {
        this.sourceIp = builder.sourceIp;
        this.url = builder.url;
    }

    public final String sourceIp() {
        return this.sourceIp;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MulticastSource)) {
            return false;
        }
        MulticastSource other = (MulticastSource)obj;
        return Objects.equals(this.sourceIp(), other.sourceIp()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"MulticastSource").add("SourceIp", (Object)this.sourceIp()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceIp": {
                return Optional.ofNullable(clazz.cast(this.sourceIp()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MulticastSource, T> g) {
        return obj -> g.apply((MulticastSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceIp;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(MulticastSource model) {
            this.sourceIp(model.sourceIp);
            this.url(model.url);
        }

        public final String getSourceIp() {
            return this.sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public MulticastSource build() {
            return new MulticastSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MulticastSource> {
        public Builder sourceIp(String var1);

        public Builder url(String var1);
    }
}

