/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagev2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagev2.model.ContainerType;
import software.amazon.awssdk.services.mediapackagev2.model.ForceEndpointErrorConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.ListDashManifestConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.ListDashManifestsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.ListHlsManifestsCopier;
import software.amazon.awssdk.services.mediapackagev2.model.ListLowLatencyHlsManifestConfiguration;
import software.amazon.awssdk.services.mediapackagev2.model.ListLowLatencyHlsManifestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginEndpointListConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginEndpointListConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::arn)).setter(OriginEndpointListConfiguration.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CHANNEL_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroupName").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::channelGroupName)).setter(OriginEndpointListConfiguration.setter(Builder::channelGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelGroupName").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::channelName)).setter(OriginEndpointListConfiguration.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> ORIGIN_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginEndpointName").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::originEndpointName)).setter(OriginEndpointListConfiguration.setter(Builder::originEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginEndpointName").build()}).build();
    private static final SdkField<String> CONTAINER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerType").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::containerTypeAsString)).setter(OriginEndpointListConfiguration.setter(Builder::containerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::description)).setter(OriginEndpointListConfiguration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::createdAt)).setter(OriginEndpointListConfiguration.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> MODIFIED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ModifiedAt").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::modifiedAt)).setter(OriginEndpointListConfiguration.setter(Builder::modifiedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedAt").build()}).build();
    private static final SdkField<List<ListHlsManifestConfiguration>> HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HlsManifests").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::hlsManifests)).setter(OriginEndpointListConfiguration.setter(Builder::hlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListHlsManifestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ListLowLatencyHlsManifestConfiguration>> LOW_LATENCY_HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LowLatencyHlsManifests").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::lowLatencyHlsManifests)).setter(OriginEndpointListConfiguration.setter(Builder::lowLatencyHlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LowLatencyHlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListLowLatencyHlsManifestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ListDashManifestConfiguration>> DASH_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DashManifests").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::dashManifests)).setter(OriginEndpointListConfiguration.setter(Builder::dashManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListDashManifestConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ForceEndpointErrorConfiguration> FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForceEndpointErrorConfiguration").getter(OriginEndpointListConfiguration.getter(OriginEndpointListConfiguration::forceEndpointErrorConfiguration)).setter(OriginEndpointListConfiguration.setter(Builder::forceEndpointErrorConfiguration)).constructor(ForceEndpointErrorConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceEndpointErrorConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_GROUP_NAME_FIELD, CHANNEL_NAME_FIELD, ORIGIN_ENDPOINT_NAME_FIELD, CONTAINER_TYPE_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, MODIFIED_AT_FIELD, HLS_MANIFESTS_FIELD, LOW_LATENCY_HLS_MANIFESTS_FIELD, DASH_MANIFESTS_FIELD, FORCE_ENDPOINT_ERROR_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String channelGroupName;
    private final String channelName;
    private final String originEndpointName;
    private final String containerType;
    private final String description;
    private final Instant createdAt;
    private final Instant modifiedAt;
    private final List<ListHlsManifestConfiguration> hlsManifests;
    private final List<ListLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests;
    private final List<ListDashManifestConfiguration> dashManifests;
    private final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;

    private OriginEndpointListConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.channelGroupName = builder.channelGroupName;
        this.channelName = builder.channelName;
        this.originEndpointName = builder.originEndpointName;
        this.containerType = builder.containerType;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.modifiedAt = builder.modifiedAt;
        this.hlsManifests = builder.hlsManifests;
        this.lowLatencyHlsManifests = builder.lowLatencyHlsManifests;
        this.dashManifests = builder.dashManifests;
        this.forceEndpointErrorConfiguration = builder.forceEndpointErrorConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final String channelGroupName() {
        return this.channelGroupName;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String originEndpointName() {
        return this.originEndpointName;
    }

    public final ContainerType containerType() {
        return ContainerType.fromValue(this.containerType);
    }

    public final String containerTypeAsString() {
        return this.containerType;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant modifiedAt() {
        return this.modifiedAt;
    }

    public final boolean hasHlsManifests() {
        return this.hlsManifests != null && !(this.hlsManifests instanceof SdkAutoConstructList);
    }

    public final List<ListHlsManifestConfiguration> hlsManifests() {
        return this.hlsManifests;
    }

    public final boolean hasLowLatencyHlsManifests() {
        return this.lowLatencyHlsManifests != null && !(this.lowLatencyHlsManifests instanceof SdkAutoConstructList);
    }

    public final List<ListLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests() {
        return this.lowLatencyHlsManifests;
    }

    public final boolean hasDashManifests() {
        return this.dashManifests != null && !(this.dashManifests instanceof SdkAutoConstructList);
    }

    public final List<ListDashManifestConfiguration> dashManifests() {
        return this.dashManifests;
    }

    public final ForceEndpointErrorConfiguration forceEndpointErrorConfiguration() {
        return this.forceEndpointErrorConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHlsManifests() ? this.hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLowLatencyHlsManifests() ? this.lowLatencyHlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDashManifests() ? this.dashManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.forceEndpointErrorConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginEndpointListConfiguration)) {
            return false;
        }
        OriginEndpointListConfiguration other = (OriginEndpointListConfiguration)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.channelGroupName(), other.channelGroupName()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.originEndpointName(), other.originEndpointName()) && Objects.equals(this.containerTypeAsString(), other.containerTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.modifiedAt(), other.modifiedAt()) && this.hasHlsManifests() == other.hasHlsManifests() && Objects.equals(this.hlsManifests(), other.hlsManifests()) && this.hasLowLatencyHlsManifests() == other.hasLowLatencyHlsManifests() && Objects.equals(this.lowLatencyHlsManifests(), other.lowLatencyHlsManifests()) && this.hasDashManifests() == other.hasDashManifests() && Objects.equals(this.dashManifests(), other.dashManifests()) && Objects.equals(this.forceEndpointErrorConfiguration(), other.forceEndpointErrorConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"OriginEndpointListConfiguration").add("Arn", (Object)this.arn()).add("ChannelGroupName", (Object)this.channelGroupName()).add("ChannelName", (Object)this.channelName()).add("OriginEndpointName", (Object)this.originEndpointName()).add("ContainerType", (Object)this.containerTypeAsString()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("ModifiedAt", (Object)this.modifiedAt()).add("HlsManifests", this.hasHlsManifests() ? this.hlsManifests() : null).add("LowLatencyHlsManifests", this.hasLowLatencyHlsManifests() ? this.lowLatencyHlsManifests() : null).add("DashManifests", this.hasDashManifests() ? this.dashManifests() : null).add("ForceEndpointErrorConfiguration", (Object)this.forceEndpointErrorConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ChannelGroupName": {
                return Optional.ofNullable(clazz.cast(this.channelGroupName()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "OriginEndpointName": {
                return Optional.ofNullable(clazz.cast(this.originEndpointName()));
            }
            case "ContainerType": {
                return Optional.ofNullable(clazz.cast(this.containerTypeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ModifiedAt": {
                return Optional.ofNullable(clazz.cast(this.modifiedAt()));
            }
            case "HlsManifests": {
                return Optional.ofNullable(clazz.cast(this.hlsManifests()));
            }
            case "LowLatencyHlsManifests": {
                return Optional.ofNullable(clazz.cast(this.lowLatencyHlsManifests()));
            }
            case "DashManifests": {
                return Optional.ofNullable(clazz.cast(this.dashManifests()));
            }
            case "ForceEndpointErrorConfiguration": {
                return Optional.ofNullable(clazz.cast(this.forceEndpointErrorConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginEndpointListConfiguration, T> g) {
        return obj -> g.apply((OriginEndpointListConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String channelGroupName;
        private String channelName;
        private String originEndpointName;
        private String containerType;
        private String description;
        private Instant createdAt;
        private Instant modifiedAt;
        private List<ListHlsManifestConfiguration> hlsManifests = DefaultSdkAutoConstructList.getInstance();
        private List<ListLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests = DefaultSdkAutoConstructList.getInstance();
        private List<ListDashManifestConfiguration> dashManifests = DefaultSdkAutoConstructList.getInstance();
        private ForceEndpointErrorConfiguration forceEndpointErrorConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginEndpointListConfiguration model) {
            this.arn(model.arn);
            this.channelGroupName(model.channelGroupName);
            this.channelName(model.channelName);
            this.originEndpointName(model.originEndpointName);
            this.containerType(model.containerType);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.modifiedAt(model.modifiedAt);
            this.hlsManifests(model.hlsManifests);
            this.lowLatencyHlsManifests(model.lowLatencyHlsManifests);
            this.dashManifests(model.dashManifests);
            this.forceEndpointErrorConfiguration(model.forceEndpointErrorConfiguration);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelGroupName() {
            return this.channelGroupName;
        }

        public final void setChannelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
        }

        @Override
        public final Builder channelGroupName(String channelGroupName) {
            this.channelGroupName = channelGroupName;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getOriginEndpointName() {
            return this.originEndpointName;
        }

        public final void setOriginEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
        }

        @Override
        public final Builder originEndpointName(String originEndpointName) {
            this.originEndpointName = originEndpointName;
            return this;
        }

        public final String getContainerType() {
            return this.containerType;
        }

        public final void setContainerType(String containerType) {
            this.containerType = containerType;
        }

        @Override
        public final Builder containerType(String containerType) {
            this.containerType = containerType;
            return this;
        }

        @Override
        public final Builder containerType(ContainerType containerType) {
            this.containerType(containerType == null ? null : containerType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getModifiedAt() {
            return this.modifiedAt;
        }

        public final void setModifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
        }

        @Override
        public final Builder modifiedAt(Instant modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public final List<ListHlsManifestConfiguration.Builder> getHlsManifests() {
            List<ListHlsManifestConfiguration.Builder> result = ListHlsManifestsCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHlsManifests(Collection<ListHlsManifestConfiguration.BuilderImpl> hlsManifests) {
            this.hlsManifests = ListHlsManifestsCopier.copyFromBuilder(hlsManifests);
        }

        @Override
        public final Builder hlsManifests(Collection<ListHlsManifestConfiguration> hlsManifests) {
            this.hlsManifests = ListHlsManifestsCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(ListHlsManifestConfiguration ... hlsManifests) {
            this.hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<ListHlsManifestConfiguration.Builder> ... hlsManifests) {
            this.hlsManifests(Stream.of(hlsManifests).map(c -> (ListHlsManifestConfiguration)((ListHlsManifestConfiguration.Builder)ListHlsManifestConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ListLowLatencyHlsManifestConfiguration.Builder> getLowLatencyHlsManifests() {
            List<ListLowLatencyHlsManifestConfiguration.Builder> result = ListLowLatencyHlsManifestsCopier.copyToBuilder(this.lowLatencyHlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLowLatencyHlsManifests(Collection<ListLowLatencyHlsManifestConfiguration.BuilderImpl> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = ListLowLatencyHlsManifestsCopier.copyFromBuilder(lowLatencyHlsManifests);
        }

        @Override
        public final Builder lowLatencyHlsManifests(Collection<ListLowLatencyHlsManifestConfiguration> lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests = ListLowLatencyHlsManifestsCopier.copy(lowLatencyHlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(ListLowLatencyHlsManifestConfiguration ... lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests(Arrays.asList(lowLatencyHlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lowLatencyHlsManifests(Consumer<ListLowLatencyHlsManifestConfiguration.Builder> ... lowLatencyHlsManifests) {
            this.lowLatencyHlsManifests(Stream.of(lowLatencyHlsManifests).map(c -> (ListLowLatencyHlsManifestConfiguration)((ListLowLatencyHlsManifestConfiguration.Builder)ListLowLatencyHlsManifestConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ListDashManifestConfiguration.Builder> getDashManifests() {
            List<ListDashManifestConfiguration.Builder> result = ListDashManifestsCopier.copyToBuilder(this.dashManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDashManifests(Collection<ListDashManifestConfiguration.BuilderImpl> dashManifests) {
            this.dashManifests = ListDashManifestsCopier.copyFromBuilder(dashManifests);
        }

        @Override
        public final Builder dashManifests(Collection<ListDashManifestConfiguration> dashManifests) {
            this.dashManifests = ListDashManifestsCopier.copy(dashManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(ListDashManifestConfiguration ... dashManifests) {
            this.dashManifests(Arrays.asList(dashManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashManifests(Consumer<ListDashManifestConfiguration.Builder> ... dashManifests) {
            this.dashManifests(Stream.of(dashManifests).map(c -> (ListDashManifestConfiguration)((ListDashManifestConfiguration.Builder)ListDashManifestConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ForceEndpointErrorConfiguration.Builder getForceEndpointErrorConfiguration() {
            return this.forceEndpointErrorConfiguration != null ? this.forceEndpointErrorConfiguration.toBuilder() : null;
        }

        public final void setForceEndpointErrorConfiguration(ForceEndpointErrorConfiguration.BuilderImpl forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration != null ? forceEndpointErrorConfiguration.build() : null;
        }

        @Override
        public final Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration forceEndpointErrorConfiguration) {
            this.forceEndpointErrorConfiguration = forceEndpointErrorConfiguration;
            return this;
        }

        public OriginEndpointListConfiguration build() {
            return new OriginEndpointListConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginEndpointListConfiguration> {
        public Builder arn(String var1);

        public Builder channelGroupName(String var1);

        public Builder channelName(String var1);

        public Builder originEndpointName(String var1);

        public Builder containerType(String var1);

        public Builder containerType(ContainerType var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder modifiedAt(Instant var1);

        public Builder hlsManifests(Collection<ListHlsManifestConfiguration> var1);

        public Builder hlsManifests(ListHlsManifestConfiguration ... var1);

        public Builder hlsManifests(Consumer<ListHlsManifestConfiguration.Builder> ... var1);

        public Builder lowLatencyHlsManifests(Collection<ListLowLatencyHlsManifestConfiguration> var1);

        public Builder lowLatencyHlsManifests(ListLowLatencyHlsManifestConfiguration ... var1);

        public Builder lowLatencyHlsManifests(Consumer<ListLowLatencyHlsManifestConfiguration.Builder> ... var1);

        public Builder dashManifests(Collection<ListDashManifestConfiguration> var1);

        public Builder dashManifests(ListDashManifestConfiguration ... var1);

        public Builder dashManifests(Consumer<ListDashManifestConfiguration.Builder> ... var1);

        public Builder forceEndpointErrorConfiguration(ForceEndpointErrorConfiguration var1);

        default public Builder forceEndpointErrorConfiguration(Consumer<ForceEndpointErrorConfiguration.Builder> forceEndpointErrorConfiguration) {
            return this.forceEndpointErrorConfiguration((ForceEndpointErrorConfiguration)((ForceEndpointErrorConfiguration.Builder)ForceEndpointErrorConfiguration.builder().applyMutation(forceEndpointErrorConfiguration)).build());
        }
    }
}

