/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StorageClass {
    TEMPORAL("TEMPORAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StorageClass> VALUE_MAP;
    private final String value;

    private StorageClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StorageClass> knownValues() {
        EnumSet<StorageClass> knownValues = EnumSet.allOf(StorageClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StorageClass.class, StorageClass::toString);
    }
}

