/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorClient;
import software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleRequest;
import software.amazon.awssdk.services.mediatailor.model.GetChannelScheduleResponse;
import software.amazon.awssdk.services.mediatailor.model.ScheduleEntry;

public class GetChannelScheduleIterable
implements SdkIterable<GetChannelScheduleResponse> {
    private final MediaTailorClient client;
    private final GetChannelScheduleRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetChannelScheduleIterable(MediaTailorClient client, GetChannelScheduleRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetChannelScheduleResponseFetcher();
    }

    public Iterator<GetChannelScheduleResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduleEntry> items() {
        Function<GetChannelScheduleResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetChannelScheduleResponseFetcher
    implements SyncPageFetcher<GetChannelScheduleResponse> {
        private GetChannelScheduleResponseFetcher() {
        }

        public boolean hasNextPage(GetChannelScheduleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetChannelScheduleResponse nextPage(GetChannelScheduleResponse previousPage) {
            if (previousPage == null) {
                return GetChannelScheduleIterable.this.client.getChannelSchedule(GetChannelScheduleIterable.this.firstRequest);
            }
            return GetChannelScheduleIterable.this.client.getChannelSchedule((GetChannelScheduleRequest)((Object)GetChannelScheduleIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

