/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEngineStatusResponse extends NeptunedataResponse implements
        ToCopyableBuilder<GetEngineStatusResponse.Builder, GetEngineStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetEngineStatusResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startTime").getter(getter(GetEngineStatusResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> DB_ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbEngineVersion").getter(getter(GetEngineStatusResponse::dbEngineVersion))
            .setter(setter(Builder::dbEngineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbEngineVersion").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("role")
            .getter(getter(GetEngineStatusResponse::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()).build();

    private static final SdkField<String> DFE_QUERY_ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dfeQueryEngine").getter(getter(GetEngineStatusResponse::dfeQueryEngine))
            .setter(setter(Builder::dfeQueryEngine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dfeQueryEngine").build()).build();

    private static final SdkField<QueryLanguageVersion> GREMLIN_FIELD = SdkField
            .<QueryLanguageVersion> builder(MarshallingType.SDK_POJO).memberName("gremlin")
            .getter(getter(GetEngineStatusResponse::gremlin)).setter(setter(Builder::gremlin))
            .constructor(QueryLanguageVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gremlin").build()).build();

    private static final SdkField<QueryLanguageVersion> SPARQL_FIELD = SdkField
            .<QueryLanguageVersion> builder(MarshallingType.SDK_POJO).memberName("sparql")
            .getter(getter(GetEngineStatusResponse::sparql)).setter(setter(Builder::sparql))
            .constructor(QueryLanguageVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparql").build()).build();

    private static final SdkField<QueryLanguageVersion> OPENCYPHER_FIELD = SdkField
            .<QueryLanguageVersion> builder(MarshallingType.SDK_POJO).memberName("opencypher")
            .getter(getter(GetEngineStatusResponse::opencypher)).setter(setter(Builder::opencypher))
            .constructor(QueryLanguageVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("opencypher").build()).build();

    private static final SdkField<Map<String, String>> LAB_MODE_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("labMode")
            .getter(getter(GetEngineStatusResponse::labMode))
            .setter(setter(Builder::labMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labMode").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> ROLLING_BACK_TRX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("rollingBackTrxCount").getter(getter(GetEngineStatusResponse::rollingBackTrxCount))
            .setter(setter(Builder::rollingBackTrxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollingBackTrxCount").build())
            .build();

    private static final SdkField<String> ROLLING_BACK_TRX_EARLIEST_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("rollingBackTrxEarliestStartTime")
            .getter(getter(GetEngineStatusResponse::rollingBackTrxEarliestStartTime))
            .setter(setter(Builder::rollingBackTrxEarliestStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollingBackTrxEarliestStartTime")
                    .build()).build();

    private static final SdkField<Map<String, Document>> FEATURES_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("features")
            .getter(getter(GetEngineStatusResponse::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SETTINGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("settings")
            .getter(getter(GetEngineStatusResponse::settings))
            .setter(setter(Builder::settings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            START_TIME_FIELD, DB_ENGINE_VERSION_FIELD, ROLE_FIELD, DFE_QUERY_ENGINE_FIELD, GREMLIN_FIELD, SPARQL_FIELD,
            OPENCYPHER_FIELD, LAB_MODE_FIELD, ROLLING_BACK_TRX_COUNT_FIELD, ROLLING_BACK_TRX_EARLIEST_START_TIME_FIELD,
            FEATURES_FIELD, SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String startTime;

    private final String dbEngineVersion;

    private final String role;

    private final String dfeQueryEngine;

    private final QueryLanguageVersion gremlin;

    private final QueryLanguageVersion sparql;

    private final QueryLanguageVersion opencypher;

    private final Map<String, String> labMode;

    private final Integer rollingBackTrxCount;

    private final String rollingBackTrxEarliestStartTime;

    private final Map<String, Document> features;

    private final Map<String, String> settings;

    private GetEngineStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.dbEngineVersion = builder.dbEngineVersion;
        this.role = builder.role;
        this.dfeQueryEngine = builder.dfeQueryEngine;
        this.gremlin = builder.gremlin;
        this.sparql = builder.sparql;
        this.opencypher = builder.opencypher;
        this.labMode = builder.labMode;
        this.rollingBackTrxCount = builder.rollingBackTrxCount;
        this.rollingBackTrxEarliestStartTime = builder.rollingBackTrxEarliestStartTime;
        this.features = builder.features;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * Set to <code>healthy</code> if the instance is not experiencing problems. If the instance is recovering from a
     * crash or from being rebooted and there are active transactions running from the latest server shutdown, status is
     * set to <code>recovery</code>.
     * </p>
     * 
     * @return Set to <code>healthy</code> if the instance is not experiencing problems. If the instance is recovering
     *         from a crash or from being rebooted and there are active transactions running from the latest server
     *         shutdown, status is set to <code>recovery</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Set to the UTC time at which the current server process started.
     * </p>
     * 
     * @return Set to the UTC time at which the current server process started.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * Set to the Neptune engine version running on your DB cluster. If this engine version has been manually patched
     * since it was released, the version number is prefixed by <code>Patch-</code>.
     * </p>
     * 
     * @return Set to the Neptune engine version running on your DB cluster. If this engine version has been manually
     *         patched since it was released, the version number is prefixed by <code>Patch-</code>.
     */
    public final String dbEngineVersion() {
        return dbEngineVersion;
    }

    /**
     * <p>
     * Set to <code>reader</code> if the instance is a read-replica, or to <code>writer</code> if the instance is the
     * primary instance.
     * </p>
     * 
     * @return Set to <code>reader</code> if the instance is a read-replica, or to <code>writer</code> if the instance
     *         is the primary instance.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * Set to <code>enabled</code> if the DFE engine is fully enabled, or to <code>viaQueryHint</code> (the default) if
     * the DFE engine is only used with queries that have the <code>useDFE</code> query hint set to <code>true</code>.
     * </p>
     * 
     * @return Set to <code>enabled</code> if the DFE engine is fully enabled, or to <code>viaQueryHint</code> (the
     *         default) if the DFE engine is only used with queries that have the <code>useDFE</code> query hint set to
     *         <code>true</code>.
     */
    public final String dfeQueryEngine() {
        return dfeQueryEngine;
    }

    /**
     * <p>
     * Contains information about the Gremlin query language available on your cluster. Specifically, it contains a
     * version field that specifies the current TinkerPop version being used by the engine.
     * </p>
     * 
     * @return Contains information about the Gremlin query language available on your cluster. Specifically, it
     *         contains a version field that specifies the current TinkerPop version being used by the engine.
     */
    public final QueryLanguageVersion gremlin() {
        return gremlin;
    }

    /**
     * <p>
     * Contains information about the SPARQL query language available on your cluster. Specifically, it contains a
     * version field that specifies the current SPARQL version being used by the engine.
     * </p>
     * 
     * @return Contains information about the SPARQL query language available on your cluster. Specifically, it contains
     *         a version field that specifies the current SPARQL version being used by the engine.
     */
    public final QueryLanguageVersion sparql() {
        return sparql;
    }

    /**
     * <p>
     * Contains information about the openCypher query language available on your cluster. Specifically, it contains a
     * version field that specifies the current operCypher version being used by the engine.
     * </p>
     * 
     * @return Contains information about the openCypher query language available on your cluster. Specifically, it
     *         contains a version field that specifies the current operCypher version being used by the engine.
     */
    public final QueryLanguageVersion opencypher() {
        return opencypher;
    }

    /**
     * For responses, this returns true if the service returned a value for the LabMode property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabMode() {
        return labMode != null && !(labMode instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains Lab Mode settings being used by the engine.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabMode} method.
     * </p>
     * 
     * @return Contains Lab Mode settings being used by the engine.
     */
    public final Map<String, String> labMode() {
        return labMode;
    }

    /**
     * <p>
     * If there are transactions being rolled back, this field is set to the number of such transactions. If there are
     * none, the field doesn't appear at all.
     * </p>
     * 
     * @return If there are transactions being rolled back, this field is set to the number of such transactions. If
     *         there are none, the field doesn't appear at all.
     */
    public final Integer rollingBackTrxCount() {
        return rollingBackTrxCount;
    }

    /**
     * <p>
     * Set to the start time of the earliest transaction being rolled back. If no transactions are being rolled back,
     * the field doesn't appear at all.
     * </p>
     * 
     * @return Set to the start time of the earliest transaction being rolled back. If no transactions are being rolled
     *         back, the field doesn't appear at all.
     */
    public final String rollingBackTrxEarliestStartTime() {
        return rollingBackTrxEarliestStartTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains status information about the features enabled on your DB cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return Contains status information about the features enabled on your DB cluster.
     */
    public final Map<String, Document> features() {
        return features;
    }

    /**
     * For responses, this returns true if the service returned a value for the Settings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSettings() {
        return settings != null && !(settings instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Contains information about the current settings on your DB cluster. For example, contains the current cluster
     * query timeout setting (<code>clusterQueryTimeoutInMs</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSettings} method.
     * </p>
     * 
     * @return Contains information about the current settings on your DB cluster. For example, contains the current
     *         cluster query timeout setting (<code>clusterQueryTimeoutInMs</code>).
     */
    public final Map<String, String> settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(dbEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(dfeQueryEngine());
        hashCode = 31 * hashCode + Objects.hashCode(gremlin());
        hashCode = 31 * hashCode + Objects.hashCode(sparql());
        hashCode = 31 * hashCode + Objects.hashCode(opencypher());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabMode() ? labMode() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rollingBackTrxCount());
        hashCode = 31 * hashCode + Objects.hashCode(rollingBackTrxEarliestStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSettings() ? settings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEngineStatusResponse)) {
            return false;
        }
        GetEngineStatusResponse other = (GetEngineStatusResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(dbEngineVersion(), other.dbEngineVersion()) && Objects.equals(role(), other.role())
                && Objects.equals(dfeQueryEngine(), other.dfeQueryEngine()) && Objects.equals(gremlin(), other.gremlin())
                && Objects.equals(sparql(), other.sparql()) && Objects.equals(opencypher(), other.opencypher())
                && hasLabMode() == other.hasLabMode() && Objects.equals(labMode(), other.labMode())
                && Objects.equals(rollingBackTrxCount(), other.rollingBackTrxCount())
                && Objects.equals(rollingBackTrxEarliestStartTime(), other.rollingBackTrxEarliestStartTime())
                && hasFeatures() == other.hasFeatures() && Objects.equals(features(), other.features())
                && hasSettings() == other.hasSettings() && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEngineStatusResponse").add("Status", status()).add("StartTime", startTime())
                .add("DbEngineVersion", dbEngineVersion()).add("Role", role()).add("DfeQueryEngine", dfeQueryEngine())
                .add("Gremlin", gremlin()).add("Sparql", sparql()).add("Opencypher", opencypher())
                .add("LabMode", hasLabMode() ? labMode() : null).add("RollingBackTrxCount", rollingBackTrxCount())
                .add("RollingBackTrxEarliestStartTime", rollingBackTrxEarliestStartTime())
                .add("Features", hasFeatures() ? features() : null).add("Settings", hasSettings() ? settings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "dbEngineVersion":
            return Optional.ofNullable(clazz.cast(dbEngineVersion()));
        case "role":
            return Optional.ofNullable(clazz.cast(role()));
        case "dfeQueryEngine":
            return Optional.ofNullable(clazz.cast(dfeQueryEngine()));
        case "gremlin":
            return Optional.ofNullable(clazz.cast(gremlin()));
        case "sparql":
            return Optional.ofNullable(clazz.cast(sparql()));
        case "opencypher":
            return Optional.ofNullable(clazz.cast(opencypher()));
        case "labMode":
            return Optional.ofNullable(clazz.cast(labMode()));
        case "rollingBackTrxCount":
            return Optional.ofNullable(clazz.cast(rollingBackTrxCount()));
        case "rollingBackTrxEarliestStartTime":
            return Optional.ofNullable(clazz.cast(rollingBackTrxEarliestStartTime()));
        case "features":
            return Optional.ofNullable(clazz.cast(features()));
        case "settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("dbEngineVersion", DB_ENGINE_VERSION_FIELD);
        map.put("role", ROLE_FIELD);
        map.put("dfeQueryEngine", DFE_QUERY_ENGINE_FIELD);
        map.put("gremlin", GREMLIN_FIELD);
        map.put("sparql", SPARQL_FIELD);
        map.put("opencypher", OPENCYPHER_FIELD);
        map.put("labMode", LAB_MODE_FIELD);
        map.put("rollingBackTrxCount", ROLLING_BACK_TRX_COUNT_FIELD);
        map.put("rollingBackTrxEarliestStartTime", ROLLING_BACK_TRX_EARLIEST_START_TIME_FIELD);
        map.put("features", FEATURES_FIELD);
        map.put("settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEngineStatusResponse, T> g) {
        return obj -> g.apply((GetEngineStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEngineStatusResponse> {
        /**
         * <p>
         * Set to <code>healthy</code> if the instance is not experiencing problems. If the instance is recovering from
         * a crash or from being rebooted and there are active transactions running from the latest server shutdown,
         * status is set to <code>recovery</code>.
         * </p>
         * 
         * @param status
         *        Set to <code>healthy</code> if the instance is not experiencing problems. If the instance is
         *        recovering from a crash or from being rebooted and there are active transactions running from the
         *        latest server shutdown, status is set to <code>recovery</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Set to the UTC time at which the current server process started.
         * </p>
         * 
         * @param startTime
         *        Set to the UTC time at which the current server process started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * Set to the Neptune engine version running on your DB cluster. If this engine version has been manually
         * patched since it was released, the version number is prefixed by <code>Patch-</code>.
         * </p>
         * 
         * @param dbEngineVersion
         *        Set to the Neptune engine version running on your DB cluster. If this engine version has been manually
         *        patched since it was released, the version number is prefixed by <code>Patch-</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbEngineVersion(String dbEngineVersion);

        /**
         * <p>
         * Set to <code>reader</code> if the instance is a read-replica, or to <code>writer</code> if the instance is
         * the primary instance.
         * </p>
         * 
         * @param role
         *        Set to <code>reader</code> if the instance is a read-replica, or to <code>writer</code> if the
         *        instance is the primary instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Set to <code>enabled</code> if the DFE engine is fully enabled, or to <code>viaQueryHint</code> (the default)
         * if the DFE engine is only used with queries that have the <code>useDFE</code> query hint set to
         * <code>true</code>.
         * </p>
         * 
         * @param dfeQueryEngine
         *        Set to <code>enabled</code> if the DFE engine is fully enabled, or to <code>viaQueryHint</code> (the
         *        default) if the DFE engine is only used with queries that have the <code>useDFE</code> query hint set
         *        to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dfeQueryEngine(String dfeQueryEngine);

        /**
         * <p>
         * Contains information about the Gremlin query language available on your cluster. Specifically, it contains a
         * version field that specifies the current TinkerPop version being used by the engine.
         * </p>
         * 
         * @param gremlin
         *        Contains information about the Gremlin query language available on your cluster. Specifically, it
         *        contains a version field that specifies the current TinkerPop version being used by the engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gremlin(QueryLanguageVersion gremlin);

        /**
         * <p>
         * Contains information about the Gremlin query language available on your cluster. Specifically, it contains a
         * version field that specifies the current TinkerPop version being used by the engine.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryLanguageVersion.Builder} avoiding
         * the need to create one manually via {@link QueryLanguageVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryLanguageVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #gremlin(QueryLanguageVersion)}.
         * 
         * @param gremlin
         *        a consumer that will call methods on {@link QueryLanguageVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gremlin(QueryLanguageVersion)
         */
        default Builder gremlin(Consumer<QueryLanguageVersion.Builder> gremlin) {
            return gremlin(QueryLanguageVersion.builder().applyMutation(gremlin).build());
        }

        /**
         * <p>
         * Contains information about the SPARQL query language available on your cluster. Specifically, it contains a
         * version field that specifies the current SPARQL version being used by the engine.
         * </p>
         * 
         * @param sparql
         *        Contains information about the SPARQL query language available on your cluster. Specifically, it
         *        contains a version field that specifies the current SPARQL version being used by the engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sparql(QueryLanguageVersion sparql);

        /**
         * <p>
         * Contains information about the SPARQL query language available on your cluster. Specifically, it contains a
         * version field that specifies the current SPARQL version being used by the engine.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryLanguageVersion.Builder} avoiding
         * the need to create one manually via {@link QueryLanguageVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryLanguageVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #sparql(QueryLanguageVersion)}.
         * 
         * @param sparql
         *        a consumer that will call methods on {@link QueryLanguageVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sparql(QueryLanguageVersion)
         */
        default Builder sparql(Consumer<QueryLanguageVersion.Builder> sparql) {
            return sparql(QueryLanguageVersion.builder().applyMutation(sparql).build());
        }

        /**
         * <p>
         * Contains information about the openCypher query language available on your cluster. Specifically, it contains
         * a version field that specifies the current operCypher version being used by the engine.
         * </p>
         * 
         * @param opencypher
         *        Contains information about the openCypher query language available on your cluster. Specifically, it
         *        contains a version field that specifies the current operCypher version being used by the engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opencypher(QueryLanguageVersion opencypher);

        /**
         * <p>
         * Contains information about the openCypher query language available on your cluster. Specifically, it contains
         * a version field that specifies the current operCypher version being used by the engine.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryLanguageVersion.Builder} avoiding
         * the need to create one manually via {@link QueryLanguageVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryLanguageVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #opencypher(QueryLanguageVersion)}.
         * 
         * @param opencypher
         *        a consumer that will call methods on {@link QueryLanguageVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opencypher(QueryLanguageVersion)
         */
        default Builder opencypher(Consumer<QueryLanguageVersion.Builder> opencypher) {
            return opencypher(QueryLanguageVersion.builder().applyMutation(opencypher).build());
        }

        /**
         * <p>
         * Contains Lab Mode settings being used by the engine.
         * </p>
         * 
         * @param labMode
         *        Contains Lab Mode settings being used by the engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labMode(Map<String, String> labMode);

        /**
         * <p>
         * If there are transactions being rolled back, this field is set to the number of such transactions. If there
         * are none, the field doesn't appear at all.
         * </p>
         * 
         * @param rollingBackTrxCount
         *        If there are transactions being rolled back, this field is set to the number of such transactions. If
         *        there are none, the field doesn't appear at all.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollingBackTrxCount(Integer rollingBackTrxCount);

        /**
         * <p>
         * Set to the start time of the earliest transaction being rolled back. If no transactions are being rolled
         * back, the field doesn't appear at all.
         * </p>
         * 
         * @param rollingBackTrxEarliestStartTime
         *        Set to the start time of the earliest transaction being rolled back. If no transactions are being
         *        rolled back, the field doesn't appear at all.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollingBackTrxEarliestStartTime(String rollingBackTrxEarliestStartTime);

        /**
         * <p>
         * Contains status information about the features enabled on your DB cluster.
         * </p>
         * 
         * @param features
         *        Contains status information about the features enabled on your DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Map<String, Document> features);

        /**
         * <p>
         * Contains information about the current settings on your DB cluster. For example, contains the current cluster
         * query timeout setting (<code>clusterQueryTimeoutInMs</code>).
         * </p>
         * 
         * @param settings
         *        Contains information about the current settings on your DB cluster. For example, contains the current
         *        cluster query timeout setting (<code>clusterQueryTimeoutInMs</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Map<String, String> settings);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String status;

        private String startTime;

        private String dbEngineVersion;

        private String role;

        private String dfeQueryEngine;

        private QueryLanguageVersion gremlin;

        private QueryLanguageVersion sparql;

        private QueryLanguageVersion opencypher;

        private Map<String, String> labMode = DefaultSdkAutoConstructMap.getInstance();

        private Integer rollingBackTrxCount;

        private String rollingBackTrxEarliestStartTime;

        private Map<String, Document> features = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> settings = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEngineStatusResponse model) {
            super(model);
            status(model.status);
            startTime(model.startTime);
            dbEngineVersion(model.dbEngineVersion);
            role(model.role);
            dfeQueryEngine(model.dfeQueryEngine);
            gremlin(model.gremlin);
            sparql(model.sparql);
            opencypher(model.opencypher);
            labMode(model.labMode);
            rollingBackTrxCount(model.rollingBackTrxCount);
            rollingBackTrxEarliestStartTime(model.rollingBackTrxEarliestStartTime);
            features(model.features);
            settings(model.settings);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStartTime() {
            return startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getDbEngineVersion() {
            return dbEngineVersion;
        }

        public final void setDbEngineVersion(String dbEngineVersion) {
            this.dbEngineVersion = dbEngineVersion;
        }

        @Override
        public final Builder dbEngineVersion(String dbEngineVersion) {
            this.dbEngineVersion = dbEngineVersion;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getDfeQueryEngine() {
            return dfeQueryEngine;
        }

        public final void setDfeQueryEngine(String dfeQueryEngine) {
            this.dfeQueryEngine = dfeQueryEngine;
        }

        @Override
        public final Builder dfeQueryEngine(String dfeQueryEngine) {
            this.dfeQueryEngine = dfeQueryEngine;
            return this;
        }

        public final QueryLanguageVersion.Builder getGremlin() {
            return gremlin != null ? gremlin.toBuilder() : null;
        }

        public final void setGremlin(QueryLanguageVersion.BuilderImpl gremlin) {
            this.gremlin = gremlin != null ? gremlin.build() : null;
        }

        @Override
        public final Builder gremlin(QueryLanguageVersion gremlin) {
            this.gremlin = gremlin;
            return this;
        }

        public final QueryLanguageVersion.Builder getSparql() {
            return sparql != null ? sparql.toBuilder() : null;
        }

        public final void setSparql(QueryLanguageVersion.BuilderImpl sparql) {
            this.sparql = sparql != null ? sparql.build() : null;
        }

        @Override
        public final Builder sparql(QueryLanguageVersion sparql) {
            this.sparql = sparql;
            return this;
        }

        public final QueryLanguageVersion.Builder getOpencypher() {
            return opencypher != null ? opencypher.toBuilder() : null;
        }

        public final void setOpencypher(QueryLanguageVersion.BuilderImpl opencypher) {
            this.opencypher = opencypher != null ? opencypher.build() : null;
        }

        @Override
        public final Builder opencypher(QueryLanguageVersion opencypher) {
            this.opencypher = opencypher;
            return this;
        }

        public final Map<String, String> getLabMode() {
            if (labMode instanceof SdkAutoConstructMap) {
                return null;
            }
            return labMode;
        }

        public final void setLabMode(Map<String, String> labMode) {
            this.labMode = StringValuedMapCopier.copy(labMode);
        }

        @Override
        public final Builder labMode(Map<String, String> labMode) {
            this.labMode = StringValuedMapCopier.copy(labMode);
            return this;
        }

        public final Integer getRollingBackTrxCount() {
            return rollingBackTrxCount;
        }

        public final void setRollingBackTrxCount(Integer rollingBackTrxCount) {
            this.rollingBackTrxCount = rollingBackTrxCount;
        }

        @Override
        public final Builder rollingBackTrxCount(Integer rollingBackTrxCount) {
            this.rollingBackTrxCount = rollingBackTrxCount;
            return this;
        }

        public final String getRollingBackTrxEarliestStartTime() {
            return rollingBackTrxEarliestStartTime;
        }

        public final void setRollingBackTrxEarliestStartTime(String rollingBackTrxEarliestStartTime) {
            this.rollingBackTrxEarliestStartTime = rollingBackTrxEarliestStartTime;
        }

        @Override
        public final Builder rollingBackTrxEarliestStartTime(String rollingBackTrxEarliestStartTime) {
            this.rollingBackTrxEarliestStartTime = rollingBackTrxEarliestStartTime;
            return this;
        }

        public final Map<String, Document> getFeatures() {
            if (features instanceof SdkAutoConstructMap) {
                return null;
            }
            return features;
        }

        public final void setFeatures(Map<String, Document> features) {
            this.features = DocumentValuedMapCopier.copy(features);
        }

        @Override
        public final Builder features(Map<String, Document> features) {
            this.features = DocumentValuedMapCopier.copy(features);
            return this;
        }

        public final Map<String, String> getSettings() {
            if (settings instanceof SdkAutoConstructMap) {
                return null;
            }
            return settings;
        }

        public final void setSettings(Map<String, String> settings) {
            this.settings = StringValuedMapCopier.copy(settings);
        }

        @Override
        @Transient
        public final Builder settings(Map<String, String> settings) {
            this.settings = StringValuedMapCopier.copy(settings);
            return this;
        }

        @Override
        public GetEngineStatusResponse build() {
            return new GetEngineStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
