/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoaderJobStatusRequest extends NeptunedataRequest implements
        ToCopyableBuilder<GetLoaderJobStatusRequest.Builder, GetLoaderJobStatusRequest> {
    private static final SdkField<String> LOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("loadId")
            .getter(getter(GetLoaderJobStatusRequest::loadId)).setter(setter(Builder::loadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("loadId").build()).build();

    private static final SdkField<Boolean> DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("details").getter(getter(GetLoaderJobStatusRequest::details)).setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("details").build()).build();

    private static final SdkField<Boolean> ERRORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("errors").getter(getter(GetLoaderJobStatusRequest::errors)).setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("errors").build()).build();

    private static final SdkField<Integer> PAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("page")
            .getter(getter(GetLoaderJobStatusRequest::page)).setter(setter(Builder::page))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("page").build()).build();

    private static final SdkField<Integer> ERRORS_PER_PAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("errorsPerPage").getter(getter(GetLoaderJobStatusRequest::errorsPerPage))
            .setter(setter(Builder::errorsPerPage))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("errorsPerPage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_ID_FIELD, DETAILS_FIELD,
            ERRORS_FIELD, PAGE_FIELD, ERRORS_PER_PAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String loadId;

    private final Boolean details;

    private final Boolean errors;

    private final Integer page;

    private final Integer errorsPerPage;

    private GetLoaderJobStatusRequest(BuilderImpl builder) {
        super(builder);
        this.loadId = builder.loadId;
        this.details = builder.details;
        this.errors = builder.errors;
        this.page = builder.page;
        this.errorsPerPage = builder.errorsPerPage;
    }

    /**
     * <p>
     * The load ID of the load job to get the status of.
     * </p>
     * 
     * @return The load ID of the load job to get the status of.
     */
    public final String loadId() {
        return loadId;
    }

    /**
     * <p>
     * Flag indicating whether or not to include details beyond the overall status (<code>TRUE</code> or
     * <code>FALSE</code>; the default is <code>FALSE</code>).
     * </p>
     * 
     * @return Flag indicating whether or not to include details beyond the overall status (<code>TRUE</code> or
     *         <code>FALSE</code>; the default is <code>FALSE</code>).
     */
    public final Boolean details() {
        return details;
    }

    /**
     * <p>
     * Flag indicating whether or not to include a list of errors encountered (<code>TRUE</code> or <code>FALSE</code>;
     * the default is <code>FALSE</code>).
     * </p>
     * <p>
     * The list of errors is paged. The <code>page</code> and <code>errorsPerPage</code> parameters allow you to page
     * through all the errors.
     * </p>
     * 
     * @return Flag indicating whether or not to include a list of errors encountered (<code>TRUE</code> or
     *         <code>FALSE</code>; the default is <code>FALSE</code>).</p>
     *         <p>
     *         The list of errors is paged. The <code>page</code> and <code>errorsPerPage</code> parameters allow you to
     *         page through all the errors.
     */
    public final Boolean errors() {
        return errors;
    }

    /**
     * <p>
     * The error page number (a positive integer; the default is <code>1</code>). Only valid when the
     * <code>errors</code> parameter is set to <code>TRUE</code>.
     * </p>
     * 
     * @return The error page number (a positive integer; the default is <code>1</code>). Only valid when the
     *         <code>errors</code> parameter is set to <code>TRUE</code>.
     */
    public final Integer page() {
        return page;
    }

    /**
     * <p>
     * The number of errors returned in each page (a positive integer; the default is <code>10</code>). Only valid when
     * the <code>errors</code> parameter set to <code>TRUE</code>.
     * </p>
     * 
     * @return The number of errors returned in each page (a positive integer; the default is <code>10</code>). Only
     *         valid when the <code>errors</code> parameter set to <code>TRUE</code>.
     */
    public final Integer errorsPerPage() {
        return errorsPerPage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadId());
        hashCode = 31 * hashCode + Objects.hashCode(details());
        hashCode = 31 * hashCode + Objects.hashCode(errors());
        hashCode = 31 * hashCode + Objects.hashCode(page());
        hashCode = 31 * hashCode + Objects.hashCode(errorsPerPage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoaderJobStatusRequest)) {
            return false;
        }
        GetLoaderJobStatusRequest other = (GetLoaderJobStatusRequest) obj;
        return Objects.equals(loadId(), other.loadId()) && Objects.equals(details(), other.details())
                && Objects.equals(errors(), other.errors()) && Objects.equals(page(), other.page())
                && Objects.equals(errorsPerPage(), other.errorsPerPage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLoaderJobStatusRequest").add("LoadId", loadId()).add("Details", details())
                .add("Errors", errors()).add("Page", page()).add("ErrorsPerPage", errorsPerPage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "loadId":
            return Optional.ofNullable(clazz.cast(loadId()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "page":
            return Optional.ofNullable(clazz.cast(page()));
        case "errorsPerPage":
            return Optional.ofNullable(clazz.cast(errorsPerPage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("loadId", LOAD_ID_FIELD);
        map.put("details", DETAILS_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("page", PAGE_FIELD);
        map.put("errorsPerPage", ERRORS_PER_PAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLoaderJobStatusRequest, T> g) {
        return obj -> g.apply((GetLoaderJobStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLoaderJobStatusRequest> {
        /**
         * <p>
         * The load ID of the load job to get the status of.
         * </p>
         * 
         * @param loadId
         *        The load ID of the load job to get the status of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadId(String loadId);

        /**
         * <p>
         * Flag indicating whether or not to include details beyond the overall status (<code>TRUE</code> or
         * <code>FALSE</code>; the default is <code>FALSE</code>).
         * </p>
         * 
         * @param details
         *        Flag indicating whether or not to include details beyond the overall status (<code>TRUE</code> or
         *        <code>FALSE</code>; the default is <code>FALSE</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Boolean details);

        /**
         * <p>
         * Flag indicating whether or not to include a list of errors encountered (<code>TRUE</code> or
         * <code>FALSE</code>; the default is <code>FALSE</code>).
         * </p>
         * <p>
         * The list of errors is paged. The <code>page</code> and <code>errorsPerPage</code> parameters allow you to
         * page through all the errors.
         * </p>
         * 
         * @param errors
         *        Flag indicating whether or not to include a list of errors encountered (<code>TRUE</code> or
         *        <code>FALSE</code>; the default is <code>FALSE</code>).</p>
         *        <p>
         *        The list of errors is paged. The <code>page</code> and <code>errorsPerPage</code> parameters allow you
         *        to page through all the errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Boolean errors);

        /**
         * <p>
         * The error page number (a positive integer; the default is <code>1</code>). Only valid when the
         * <code>errors</code> parameter is set to <code>TRUE</code>.
         * </p>
         * 
         * @param page
         *        The error page number (a positive integer; the default is <code>1</code>). Only valid when the
         *        <code>errors</code> parameter is set to <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder page(Integer page);

        /**
         * <p>
         * The number of errors returned in each page (a positive integer; the default is <code>10</code>). Only valid
         * when the <code>errors</code> parameter set to <code>TRUE</code>.
         * </p>
         * 
         * @param errorsPerPage
         *        The number of errors returned in each page (a positive integer; the default is <code>10</code>). Only
         *        valid when the <code>errors</code> parameter set to <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorsPerPage(Integer errorsPerPage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private String loadId;

        private Boolean details;

        private Boolean errors;

        private Integer page;

        private Integer errorsPerPage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoaderJobStatusRequest model) {
            super(model);
            loadId(model.loadId);
            details(model.details);
            errors(model.errors);
            page(model.page);
            errorsPerPage(model.errorsPerPage);
        }

        public final String getLoadId() {
            return loadId;
        }

        public final void setLoadId(String loadId) {
            this.loadId = loadId;
        }

        @Override
        public final Builder loadId(String loadId) {
            this.loadId = loadId;
            return this;
        }

        public final Boolean getDetails() {
            return details;
        }

        public final void setDetails(Boolean details) {
            this.details = details;
        }

        @Override
        public final Builder details(Boolean details) {
            this.details = details;
            return this;
        }

        public final Boolean getErrors() {
            return errors;
        }

        public final void setErrors(Boolean errors) {
            this.errors = errors;
        }

        @Override
        public final Builder errors(Boolean errors) {
            this.errors = errors;
            return this;
        }

        public final Integer getPage() {
            return page;
        }

        public final void setPage(Integer page) {
            this.page = page;
        }

        @Override
        public final Builder page(Integer page) {
            this.page = page;
            return this;
        }

        public final Integer getErrorsPerPage() {
            return errorsPerPage;
        }

        public final void setErrorsPerPage(Integer errorsPerPage) {
            this.errorsPerPage = errorsPerPage;
        }

        @Override
        public final Builder errorsPerPage(Integer errorsPerPage) {
            this.errorsPerPage = errorsPerPage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLoaderJobStatusRequest build() {
            return new GetLoaderJobStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
