/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoaderJobStatusResponse extends NeptunedataResponse implements
        ToCopyableBuilder<GetLoaderJobStatusResponse.Builder, GetLoaderJobStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetLoaderJobStatusResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Document> PAYLOAD_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("payload").getter(getter(GetLoaderJobStatusResponse::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, PAYLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final Document payload;

    private GetLoaderJobStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The HTTP response code for the request.
     * </p>
     * 
     * @return The HTTP response code for the request.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Status information about the load job, in a layout that could look like this:
     * </p>
     * 
     * @return Status information about the load job, in a layout that could look like this:
     */
    public final Document payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoaderJobStatusResponse)) {
            return false;
        }
        GetLoaderJobStatusResponse other = (GetLoaderJobStatusResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLoaderJobStatusResponse").add("Status", status()).add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLoaderJobStatusResponse, T> g) {
        return obj -> g.apply((GetLoaderJobStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLoaderJobStatusResponse> {
        /**
         * <p>
         * The HTTP response code for the request.
         * </p>
         * 
         * @param status
         *        The HTTP response code for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Status information about the load job, in a layout that could look like this:
         * </p>
         * 
         * @param payload
         *        Status information about the load job, in a layout that could look like this:
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Document payload);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String status;

        private Document payload;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoaderJobStatusResponse model) {
            super(model);
            status(model.status);
            payload(model.payload);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Document getPayload() {
            return payload;
        }

        public final void setPayload(Document payload) {
            this.payload = payload;
        }

        @Override
        public final Builder payload(Document payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public GetLoaderJobStatusResponse build() {
            return new GetLoaderJobStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
