/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlDataProcessingJobResponse extends NeptunedataResponse implements
        ToCopyableBuilder<GetMlDataProcessingJobResponse.Builder, GetMlDataProcessingJobResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetMlDataProcessingJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetMlDataProcessingJobResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<MlResourceDefinition> PROCESSING_JOB_FIELD = SdkField
            .<MlResourceDefinition> builder(MarshallingType.SDK_POJO).memberName("processingJob")
            .getter(getter(GetMlDataProcessingJobResponse::processingJob)).setter(setter(Builder::processingJob))
            .constructor(MlResourceDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingJob").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ID_FIELD,
            PROCESSING_JOB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final String id;

    private final MlResourceDefinition processingJob;

    private GetMlDataProcessingJobResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.id = builder.id;
        this.processingJob = builder.processingJob;
    }

    /**
     * <p>
     * Status of the data processing job.
     * </p>
     * 
     * @return Status of the data processing job.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The unique identifier of this data-processing job.
     * </p>
     * 
     * @return The unique identifier of this data-processing job.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Definition of the data processing job.
     * </p>
     * 
     * @return Definition of the data processing job.
     */
    public final MlResourceDefinition processingJob() {
        return processingJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(processingJob());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlDataProcessingJobResponse)) {
            return false;
        }
        GetMlDataProcessingJobResponse other = (GetMlDataProcessingJobResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(id(), other.id())
                && Objects.equals(processingJob(), other.processingJob());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMlDataProcessingJobResponse").add("Status", status()).add("Id", id())
                .add("ProcessingJob", processingJob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "processingJob":
            return Optional.ofNullable(clazz.cast(processingJob()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("status", STATUS_FIELD);
        map.put("id", ID_FIELD);
        map.put("processingJob", PROCESSING_JOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMlDataProcessingJobResponse, T> g) {
        return obj -> g.apply((GetMlDataProcessingJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMlDataProcessingJobResponse> {
        /**
         * <p>
         * Status of the data processing job.
         * </p>
         * 
         * @param status
         *        Status of the data processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The unique identifier of this data-processing job.
         * </p>
         * 
         * @param id
         *        The unique identifier of this data-processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Definition of the data processing job.
         * </p>
         * 
         * @param processingJob
         *        Definition of the data processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingJob(MlResourceDefinition processingJob);

        /**
         * <p>
         * Definition of the data processing job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MlResourceDefinition.Builder} avoiding
         * the need to create one manually via {@link MlResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MlResourceDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #processingJob(MlResourceDefinition)}.
         * 
         * @param processingJob
         *        a consumer that will call methods on {@link MlResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingJob(MlResourceDefinition)
         */
        default Builder processingJob(Consumer<MlResourceDefinition.Builder> processingJob) {
            return processingJob(MlResourceDefinition.builder().applyMutation(processingJob).build());
        }
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String status;

        private String id;

        private MlResourceDefinition processingJob;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlDataProcessingJobResponse model) {
            super(model);
            status(model.status);
            id(model.id);
            processingJob(model.processingJob);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MlResourceDefinition.Builder getProcessingJob() {
            return processingJob != null ? processingJob.toBuilder() : null;
        }

        public final void setProcessingJob(MlResourceDefinition.BuilderImpl processingJob) {
            this.processingJob = processingJob != null ? processingJob.build() : null;
        }

        @Override
        public final Builder processingJob(MlResourceDefinition processingJob) {
            this.processingJob = processingJob;
            return this;
        }

        @Override
        public GetMlDataProcessingJobResponse build() {
            return new GetMlDataProcessingJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
