/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMlEndpointsRequest extends NeptunedataRequest implements
        ToCopyableBuilder<ListMlEndpointsRequest.Builder, ListMlEndpointsRequest> {
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxItems").getter(getter(ListMlEndpointsRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxItems").build()).build();

    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("neptuneIamRoleArn").getter(getter(ListMlEndpointsRequest::neptuneIamRoleArn))
            .setter(setter(Builder::neptuneIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("neptuneIamRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ITEMS_FIELD,
            NEPTUNE_IAM_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxItems;

    private final String neptuneIamRoleArn;

    private ListMlEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.maxItems = builder.maxItems;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
    }

    /**
     * <p>
     * The maximum number of items to return (from 1 to 1024; the default is 10.
     * </p>
     * 
     * @return The maximum number of items to return (from 1 to 1024; the default is 10.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed in
     * your DB cluster parameter group or an error will occur.
     * </p>
     * 
     * @return The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
     *         listed in your DB cluster parameter group or an error will occur.
     */
    public final String neptuneIamRoleArn() {
        return neptuneIamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(neptuneIamRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMlEndpointsRequest)) {
            return false;
        }
        ListMlEndpointsRequest other = (ListMlEndpointsRequest) obj;
        return Objects.equals(maxItems(), other.maxItems()) && Objects.equals(neptuneIamRoleArn(), other.neptuneIamRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMlEndpointsRequest").add("MaxItems", maxItems())
                .add("NeptuneIamRoleArn", neptuneIamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "neptuneIamRoleArn":
            return Optional.ofNullable(clazz.cast(neptuneIamRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxItems", MAX_ITEMS_FIELD);
        map.put("neptuneIamRoleArn", NEPTUNE_IAM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMlEndpointsRequest, T> g) {
        return obj -> g.apply((ListMlEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListMlEndpointsRequest> {
        /**
         * <p>
         * The maximum number of items to return (from 1 to 1024; the default is 10.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of items to return (from 1 to 1024; the default is 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be listed
         * in your DB cluster parameter group or an error will occur.
         * </p>
         * 
         * @param neptuneIamRoleArn
         *        The ARN of an IAM role that provides Neptune access to SageMaker and Amazon S3 resources. This must be
         *        listed in your DB cluster parameter group or an error will occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neptuneIamRoleArn(String neptuneIamRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptunedataRequest.BuilderImpl implements Builder {
        private Integer maxItems;

        private String neptuneIamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMlEndpointsRequest model) {
            super(model);
            maxItems(model.maxItems);
            neptuneIamRoleArn(model.neptuneIamRoleArn);
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMlEndpointsRequest build() {
            return new ListMlEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
