/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkmonitor.model.CreateMonitorProbeInput;
import software.amazon.awssdk.services.networkmonitor.model.CreateMonitorProbeInputListCopier;
import software.amazon.awssdk.services.networkmonitor.model.NetworkMonitorRequest;
import software.amazon.awssdk.services.networkmonitor.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMonitorRequest
extends NetworkMonitorRequest
implements ToCopyableBuilder<Builder, CreateMonitorRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorName").getter(CreateMonitorRequest.getter(CreateMonitorRequest::monitorName)).setter(CreateMonitorRequest.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitorName").build()}).build();
    private static final SdkField<List<CreateMonitorProbeInput>> PROBES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("probes").getter(CreateMonitorRequest.getter(CreateMonitorRequest::probes)).setter(CreateMonitorRequest.setter(Builder::probes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("probes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateMonitorProbeInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("aggregationPeriod").getter(CreateMonitorRequest.getter(CreateMonitorRequest::aggregationPeriod)).setter(CreateMonitorRequest.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationPeriod").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateMonitorRequest.getter(CreateMonitorRequest::clientToken)).setter(CreateMonitorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateMonitorRequest.getter(CreateMonitorRequest::tags)).setter(CreateMonitorRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, PROBES_FIELD, AGGREGATION_PERIOD_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private final String monitorName;
    private final List<CreateMonitorProbeInput> probes;
    private final Long aggregationPeriod;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.probes = builder.probes;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final boolean hasProbes() {
        return this.probes != null && !(this.probes instanceof SdkAutoConstructList);
    }

    public final List<CreateMonitorProbeInput> probes() {
        return this.probes;
    }

    public final Long aggregationPeriod() {
        return this.aggregationPeriod;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProbes() ? this.probes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorRequest)) {
            return false;
        }
        CreateMonitorRequest other = (CreateMonitorRequest)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && this.hasProbes() == other.hasProbes() && Objects.equals(this.probes(), other.probes()) && Objects.equals(this.aggregationPeriod(), other.aggregationPeriod()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMonitorRequest").add("MonitorName", (Object)this.monitorName()).add("Probes", this.hasProbes() ? this.probes() : null).add("AggregationPeriod", (Object)this.aggregationPeriod()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "probes": {
                return Optional.ofNullable(clazz.cast(this.probes()));
            }
            case "aggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriod()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMonitorRequest, T> g) {
        return obj -> g.apply((CreateMonitorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkMonitorRequest.BuilderImpl
    implements Builder {
        private String monitorName;
        private List<CreateMonitorProbeInput> probes = DefaultSdkAutoConstructList.getInstance();
        private Long aggregationPeriod;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMonitorRequest model) {
            super(model);
            this.monitorName(model.monitorName);
            this.probes(model.probes);
            this.aggregationPeriod(model.aggregationPeriod);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final List<CreateMonitorProbeInput.Builder> getProbes() {
            List<CreateMonitorProbeInput.Builder> result = CreateMonitorProbeInputListCopier.copyToBuilder(this.probes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProbes(Collection<CreateMonitorProbeInput.BuilderImpl> probes) {
            this.probes = CreateMonitorProbeInputListCopier.copyFromBuilder(probes);
        }

        @Override
        public final Builder probes(Collection<CreateMonitorProbeInput> probes) {
            this.probes = CreateMonitorProbeInputListCopier.copy(probes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder probes(CreateMonitorProbeInput ... probes) {
            this.probes(Arrays.asList(probes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder probes(Consumer<CreateMonitorProbeInput.Builder> ... probes) {
            this.probes(Stream.of(probes).map(c -> (CreateMonitorProbeInput)((CreateMonitorProbeInput.Builder)CreateMonitorProbeInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(Long aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(Long aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMonitorRequest build() {
            return new CreateMonitorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NetworkMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMonitorRequest> {
        public Builder monitorName(String var1);

        public Builder probes(Collection<CreateMonitorProbeInput> var1);

        public Builder probes(CreateMonitorProbeInput ... var1);

        public Builder probes(Consumer<CreateMonitorProbeInput.Builder> ... var1);

        public Builder aggregationPeriod(Long var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

