/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmonitor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmonitor.model.NetworkMonitorRequest;
import software.amazon.awssdk.services.networkmonitor.model.ProbeState;
import software.amazon.awssdk.services.networkmonitor.model.Protocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProbeRequest
extends NetworkMonitorRequest
implements ToCopyableBuilder<Builder, UpdateProbeRequest> {
    private static final SdkField<String> MONITOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("monitorName").getter(UpdateProbeRequest.getter(UpdateProbeRequest::monitorName)).setter(UpdateProbeRequest.setter(Builder::monitorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("monitorName").build()}).build();
    private static final SdkField<String> PROBE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("probeId").getter(UpdateProbeRequest.getter(UpdateProbeRequest::probeId)).setter(UpdateProbeRequest.setter(Builder::probeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("probeId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(UpdateProbeRequest.getter(UpdateProbeRequest::stateAsString)).setter(UpdateProbeRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destination").getter(UpdateProbeRequest.getter(UpdateProbeRequest::destination)).setter(UpdateProbeRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("destinationPort").getter(UpdateProbeRequest.getter(UpdateProbeRequest::destinationPort)).setter(UpdateProbeRequest.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(UpdateProbeRequest.getter(UpdateProbeRequest::protocolAsString)).setter(UpdateProbeRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Integer> PACKET_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("packetSize").getter(UpdateProbeRequest.getter(UpdateProbeRequest::packetSize)).setter(UpdateProbeRequest.setter(Builder::packetSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packetSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_NAME_FIELD, PROBE_ID_FIELD, STATE_FIELD, DESTINATION_FIELD, DESTINATION_PORT_FIELD, PROTOCOL_FIELD, PACKET_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("monitorName", MONITOR_NAME_FIELD);
            this.put("probeId", PROBE_ID_FIELD);
            this.put("state", STATE_FIELD);
            this.put("destination", DESTINATION_FIELD);
            this.put("destinationPort", DESTINATION_PORT_FIELD);
            this.put("protocol", PROTOCOL_FIELD);
            this.put("packetSize", PACKET_SIZE_FIELD);
        }
    });
    private final String monitorName;
    private final String probeId;
    private final String state;
    private final String destination;
    private final Integer destinationPort;
    private final String protocol;
    private final Integer packetSize;

    private UpdateProbeRequest(BuilderImpl builder) {
        super(builder);
        this.monitorName = builder.monitorName;
        this.probeId = builder.probeId;
        this.state = builder.state;
        this.destination = builder.destination;
        this.destinationPort = builder.destinationPort;
        this.protocol = builder.protocol;
        this.packetSize = builder.packetSize;
    }

    public final String monitorName() {
        return this.monitorName;
    }

    public final String probeId() {
        return this.probeId;
    }

    public final ProbeState state() {
        return ProbeState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String destination() {
        return this.destination;
    }

    public final Integer destinationPort() {
        return this.destinationPort;
    }

    public final Protocol protocol() {
        return Protocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final Integer packetSize() {
        return this.packetSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.probeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProbeRequest)) {
            return false;
        }
        UpdateProbeRequest other = (UpdateProbeRequest)((Object)obj);
        return Objects.equals(this.monitorName(), other.monitorName()) && Objects.equals(this.probeId(), other.probeId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationPort(), other.destinationPort()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.packetSize(), other.packetSize());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProbeRequest").add("MonitorName", (Object)this.monitorName()).add("ProbeId", (Object)this.probeId()).add("State", (Object)this.stateAsString()).add("Destination", (Object)this.destination()).add("DestinationPort", (Object)this.destinationPort()).add("Protocol", (Object)this.protocolAsString()).add("PacketSize", (Object)this.packetSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monitorName": {
                return Optional.ofNullable(clazz.cast(this.monitorName()));
            }
            case "probeId": {
                return Optional.ofNullable(clazz.cast(this.probeId()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "destinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "packetSize": {
                return Optional.ofNullable(clazz.cast(this.packetSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProbeRequest, T> g) {
        return obj -> g.apply((UpdateProbeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkMonitorRequest.BuilderImpl
    implements Builder {
        private String monitorName;
        private String probeId;
        private String state;
        private String destination;
        private Integer destinationPort;
        private String protocol;
        private Integer packetSize;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProbeRequest model) {
            super(model);
            this.monitorName(model.monitorName);
            this.probeId(model.probeId);
            this.state(model.state);
            this.destination(model.destination);
            this.destinationPort(model.destinationPort);
            this.protocol(model.protocol);
            this.packetSize(model.packetSize);
        }

        public final String getMonitorName() {
            return this.monitorName;
        }

        public final void setMonitorName(String monitorName) {
            this.monitorName = monitorName;
        }

        @Override
        public final Builder monitorName(String monitorName) {
            this.monitorName = monitorName;
            return this;
        }

        public final String getProbeId() {
            return this.probeId;
        }

        public final void setProbeId(String probeId) {
            this.probeId = probeId;
        }

        @Override
        public final Builder probeId(String probeId) {
            this.probeId = probeId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ProbeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final Integer getDestinationPort() {
            return this.destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPacketSize() {
            return this.packetSize;
        }

        public final void setPacketSize(Integer packetSize) {
            this.packetSize = packetSize;
        }

        @Override
        public final Builder packetSize(Integer packetSize) {
            this.packetSize = packetSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProbeRequest build() {
            return new UpdateProbeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkMonitorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProbeRequest> {
        public Builder monitorName(String var1);

        public Builder probeId(String var1);

        public Builder state(String var1);

        public Builder state(ProbeState var1);

        public Builder destination(String var1);

        public Builder destinationPort(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder packetSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

