/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.organizations.model.ActionType;
import software.amazon.awssdk.services.organizations.model.HandshakePartiesCopier;
import software.amazon.awssdk.services.organizations.model.HandshakeParty;
import software.amazon.awssdk.services.organizations.model.HandshakeResource;
import software.amazon.awssdk.services.organizations.model.HandshakeResourcesCopier;
import software.amazon.awssdk.services.organizations.model.HandshakeState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Handshake
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Handshake> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Handshake.getter(Handshake::id)).setter(Handshake.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Handshake.getter(Handshake::arn)).setter(Handshake.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<List<HandshakeParty>> PARTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parties").getter(Handshake.getter(Handshake::parties)).setter(Handshake.setter(Builder::parties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HandshakeParty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Handshake.getter(Handshake::stateAsString)).setter(Handshake.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> REQUESTED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestedTimestamp").getter(Handshake.getter(Handshake::requestedTimestamp)).setter(Handshake.setter(Builder::requestedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedTimestamp").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationTimestamp").getter(Handshake.getter(Handshake::expirationTimestamp)).setter(Handshake.setter(Builder::expirationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTimestamp").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(Handshake.getter(Handshake::actionAsString)).setter(Handshake.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<List<HandshakeResource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(Handshake.getter(Handshake::resources)).setter(Handshake.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HandshakeResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, PARTIES_FIELD, STATE_FIELD, REQUESTED_TIMESTAMP_FIELD, EXPIRATION_TIMESTAMP_FIELD, ACTION_FIELD, RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Id", ID_FIELD);
            this.put("Arn", ARN_FIELD);
            this.put("Parties", PARTIES_FIELD);
            this.put("State", STATE_FIELD);
            this.put("RequestedTimestamp", REQUESTED_TIMESTAMP_FIELD);
            this.put("ExpirationTimestamp", EXPIRATION_TIMESTAMP_FIELD);
            this.put("Action", ACTION_FIELD);
            this.put("Resources", RESOURCES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final List<HandshakeParty> parties;
    private final String state;
    private final Instant requestedTimestamp;
    private final Instant expirationTimestamp;
    private final String action;
    private final List<HandshakeResource> resources;

    private Handshake(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.parties = builder.parties;
        this.state = builder.state;
        this.requestedTimestamp = builder.requestedTimestamp;
        this.expirationTimestamp = builder.expirationTimestamp;
        this.action = builder.action;
        this.resources = builder.resources;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasParties() {
        return this.parties != null && !(this.parties instanceof SdkAutoConstructList);
    }

    public final List<HandshakeParty> parties() {
        return this.parties;
    }

    public final HandshakeState state() {
        return HandshakeState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant requestedTimestamp() {
        return this.requestedTimestamp;
    }

    public final Instant expirationTimestamp() {
        return this.expirationTimestamp;
    }

    public final ActionType action() {
        return ActionType.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<HandshakeResource> resources() {
        return this.resources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParties() ? this.parties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Handshake)) {
            return false;
        }
        Handshake other = (Handshake)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && this.hasParties() == other.hasParties() && Objects.equals(this.parties(), other.parties()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.requestedTimestamp(), other.requestedTimestamp()) && Objects.equals(this.expirationTimestamp(), other.expirationTimestamp()) && Objects.equals(this.actionAsString(), other.actionAsString()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources());
    }

    public final String toString() {
        return ToString.builder((String)"Handshake").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Parties", this.hasParties() ? this.parties() : null).add("State", (Object)this.stateAsString()).add("RequestedTimestamp", (Object)this.requestedTimestamp()).add("ExpirationTimestamp", (Object)this.expirationTimestamp()).add("Action", (Object)this.actionAsString()).add("Resources", this.hasResources() ? this.resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Parties": {
                return Optional.ofNullable(clazz.cast(this.parties()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "RequestedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.requestedTimestamp()));
            }
            case "ExpirationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.expirationTimestamp()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Handshake, T> g) {
        return obj -> g.apply((Handshake)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private List<HandshakeParty> parties = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private Instant requestedTimestamp;
        private Instant expirationTimestamp;
        private String action;
        private List<HandshakeResource> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Handshake model) {
            this.id(model.id);
            this.arn(model.arn);
            this.parties(model.parties);
            this.state(model.state);
            this.requestedTimestamp(model.requestedTimestamp);
            this.expirationTimestamp(model.expirationTimestamp);
            this.action(model.action);
            this.resources(model.resources);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<HandshakeParty.Builder> getParties() {
            List<HandshakeParty.Builder> result = HandshakePartiesCopier.copyToBuilder(this.parties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParties(Collection<HandshakeParty.BuilderImpl> parties) {
            this.parties = HandshakePartiesCopier.copyFromBuilder(parties);
        }

        @Override
        public final Builder parties(Collection<HandshakeParty> parties) {
            this.parties = HandshakePartiesCopier.copy(parties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parties(HandshakeParty ... parties) {
            this.parties(Arrays.asList(parties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parties(Consumer<HandshakeParty.Builder> ... parties) {
            this.parties(Stream.of(parties).map(c -> (HandshakeParty)((HandshakeParty.Builder)HandshakeParty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(HandshakeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getRequestedTimestamp() {
            return this.requestedTimestamp;
        }

        public final void setRequestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
        }

        @Override
        public final Builder requestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
            return this;
        }

        public final Instant getExpirationTimestamp() {
            return this.expirationTimestamp;
        }

        public final void setExpirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
        }

        @Override
        public final Builder expirationTimestamp(Instant expirationTimestamp) {
            this.expirationTimestamp = expirationTimestamp;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ActionType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<HandshakeResource.Builder> getResources() {
            List<HandshakeResource.Builder> result = HandshakeResourcesCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<HandshakeResource.BuilderImpl> resources) {
            this.resources = HandshakeResourcesCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<HandshakeResource> resources) {
            this.resources = HandshakeResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(HandshakeResource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<HandshakeResource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (HandshakeResource)((HandshakeResource.Builder)HandshakeResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Handshake build() {
            return new Handshake(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Handshake> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder parties(Collection<HandshakeParty> var1);

        public Builder parties(HandshakeParty ... var1);

        public Builder parties(Consumer<HandshakeParty.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(HandshakeState var1);

        public Builder requestedTimestamp(Instant var1);

        public Builder expirationTimestamp(Instant var1);

        public Builder action(String var1);

        public Builder action(ActionType var1);

        public Builder resources(Collection<HandshakeResource> var1);

        public Builder resources(HandshakeResource ... var1);

        public Builder resources(Consumer<HandshakeResource.Builder> ... var1);
    }
}

