/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit;

public class DescribeSpendLimitsIterable
implements SdkIterable<DescribeSpendLimitsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeSpendLimitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSpendLimitsIterable(PinpointSmsVoiceV2Client client, DescribeSpendLimitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSpendLimitsResponseFetcher();
    }

    public Iterator<DescribeSpendLimitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpendLimit> spendLimits() {
        Function<DescribeSpendLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.spendLimits() != null) {
                return response.spendLimits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSpendLimitsResponseFetcher
    implements SyncPageFetcher<DescribeSpendLimitsResponse> {
        private DescribeSpendLimitsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpendLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSpendLimitsResponse nextPage(DescribeSpendLimitsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpendLimitsIterable.this.client.describeSpendLimits(DescribeSpendLimitsIterable.this.firstRequest);
            }
            return DescribeSpendLimitsIterable.this.client.describeSpendLimits((DescribeSpendLimitsRequest)((Object)DescribeSpendLimitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

