/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.NumberCapability;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationCountryRuleSetCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationCountryRuleSetInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProtectConfigurationCountryRuleSetResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, GetProtectConfigurationCountryRuleSetResponse> {
    private static final SdkField<String> PROTECT_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationArn").getter(GetProtectConfigurationCountryRuleSetResponse.getter(GetProtectConfigurationCountryRuleSetResponse::protectConfigurationArn)).setter(GetProtectConfigurationCountryRuleSetResponse.setter(Builder::protectConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationArn").build()}).build();
    private static final SdkField<String> PROTECT_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProtectConfigurationId").getter(GetProtectConfigurationCountryRuleSetResponse.getter(GetProtectConfigurationCountryRuleSetResponse::protectConfigurationId)).setter(GetProtectConfigurationCountryRuleSetResponse.setter(Builder::protectConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectConfigurationId").build()}).build();
    private static final SdkField<String> NUMBER_CAPABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberCapability").getter(GetProtectConfigurationCountryRuleSetResponse.getter(GetProtectConfigurationCountryRuleSetResponse::numberCapabilityAsString)).setter(GetProtectConfigurationCountryRuleSetResponse.setter(Builder::numberCapability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberCapability").build()}).build();
    private static final SdkField<Map<String, ProtectConfigurationCountryRuleSetInformation>> COUNTRY_RULE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CountryRuleSet").getter(GetProtectConfigurationCountryRuleSetResponse.getter(GetProtectConfigurationCountryRuleSetResponse::countryRuleSet)).setter(GetProtectConfigurationCountryRuleSetResponse.setter(Builder::countryRuleSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryRuleSet").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectConfigurationCountryRuleSetInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECT_CONFIGURATION_ARN_FIELD, PROTECT_CONFIGURATION_ID_FIELD, NUMBER_CAPABILITY_FIELD, COUNTRY_RULE_SET_FIELD));
    private final String protectConfigurationArn;
    private final String protectConfigurationId;
    private final String numberCapability;
    private final Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSet;

    private GetProtectConfigurationCountryRuleSetResponse(BuilderImpl builder) {
        super(builder);
        this.protectConfigurationArn = builder.protectConfigurationArn;
        this.protectConfigurationId = builder.protectConfigurationId;
        this.numberCapability = builder.numberCapability;
        this.countryRuleSet = builder.countryRuleSet;
    }

    public final String protectConfigurationArn() {
        return this.protectConfigurationArn;
    }

    public final String protectConfigurationId() {
        return this.protectConfigurationId;
    }

    public final NumberCapability numberCapability() {
        return NumberCapability.fromValue(this.numberCapability);
    }

    public final String numberCapabilityAsString() {
        return this.numberCapability;
    }

    public final boolean hasCountryRuleSet() {
        return this.countryRuleSet != null && !(this.countryRuleSet instanceof SdkAutoConstructMap);
    }

    public final Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSet() {
        return this.countryRuleSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.protectConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberCapabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountryRuleSet() ? this.countryRuleSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProtectConfigurationCountryRuleSetResponse)) {
            return false;
        }
        GetProtectConfigurationCountryRuleSetResponse other = (GetProtectConfigurationCountryRuleSetResponse)((Object)obj);
        return Objects.equals(this.protectConfigurationArn(), other.protectConfigurationArn()) && Objects.equals(this.protectConfigurationId(), other.protectConfigurationId()) && Objects.equals(this.numberCapabilityAsString(), other.numberCapabilityAsString()) && this.hasCountryRuleSet() == other.hasCountryRuleSet() && Objects.equals(this.countryRuleSet(), other.countryRuleSet());
    }

    public final String toString() {
        return ToString.builder((String)"GetProtectConfigurationCountryRuleSetResponse").add("ProtectConfigurationArn", (Object)this.protectConfigurationArn()).add("ProtectConfigurationId", (Object)this.protectConfigurationId()).add("NumberCapability", (Object)this.numberCapabilityAsString()).add("CountryRuleSet", this.hasCountryRuleSet() ? this.countryRuleSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProtectConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationArn()));
            }
            case "ProtectConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.protectConfigurationId()));
            }
            case "NumberCapability": {
                return Optional.ofNullable(clazz.cast(this.numberCapabilityAsString()));
            }
            case "CountryRuleSet": {
                return Optional.ofNullable(clazz.cast(this.countryRuleSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProtectConfigurationCountryRuleSetResponse, T> g) {
        return obj -> g.apply((GetProtectConfigurationCountryRuleSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String protectConfigurationArn;
        private String protectConfigurationId;
        private String numberCapability;
        private Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSet = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProtectConfigurationCountryRuleSetResponse model) {
            super(model);
            this.protectConfigurationArn(model.protectConfigurationArn);
            this.protectConfigurationId(model.protectConfigurationId);
            this.numberCapability(model.numberCapability);
            this.countryRuleSet(model.countryRuleSet);
        }

        public final String getProtectConfigurationArn() {
            return this.protectConfigurationArn;
        }

        public final void setProtectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
        }

        @Override
        public final Builder protectConfigurationArn(String protectConfigurationArn) {
            this.protectConfigurationArn = protectConfigurationArn;
            return this;
        }

        public final String getProtectConfigurationId() {
            return this.protectConfigurationId;
        }

        public final void setProtectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
        }

        @Override
        public final Builder protectConfigurationId(String protectConfigurationId) {
            this.protectConfigurationId = protectConfigurationId;
            return this;
        }

        public final String getNumberCapability() {
            return this.numberCapability;
        }

        public final void setNumberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
        }

        @Override
        public final Builder numberCapability(String numberCapability) {
            this.numberCapability = numberCapability;
            return this;
        }

        @Override
        public final Builder numberCapability(NumberCapability numberCapability) {
            this.numberCapability(numberCapability == null ? null : numberCapability.toString());
            return this;
        }

        public final Map<String, ProtectConfigurationCountryRuleSetInformation.Builder> getCountryRuleSet() {
            Map<String, ProtectConfigurationCountryRuleSetInformation.Builder> result = ProtectConfigurationCountryRuleSetCopier.copyToBuilder(this.countryRuleSet);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCountryRuleSet(Map<String, ProtectConfigurationCountryRuleSetInformation.BuilderImpl> countryRuleSet) {
            this.countryRuleSet = ProtectConfigurationCountryRuleSetCopier.copyFromBuilder(countryRuleSet);
        }

        @Override
        public final Builder countryRuleSet(Map<String, ProtectConfigurationCountryRuleSetInformation> countryRuleSet) {
            this.countryRuleSet = ProtectConfigurationCountryRuleSetCopier.copy(countryRuleSet);
            return this;
        }

        @Override
        public GetProtectConfigurationCountryRuleSetResponse build() {
            return new GetProtectConfigurationCountryRuleSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProtectConfigurationCountryRuleSetResponse> {
        public Builder protectConfigurationArn(String var1);

        public Builder protectConfigurationId(String var1);

        public Builder numberCapability(String var1);

        public Builder numberCapability(NumberCapability var1);

        public Builder countryRuleSet(Map<String, ProtectConfigurationCountryRuleSetInformation> var1);
    }
}

