/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.AttachmentStatus;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Response;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRegistrationAttachmentResponse
extends PinpointSmsVoiceV2Response
implements ToCopyableBuilder<Builder, CreateRegistrationAttachmentResponse> {
    private static final SdkField<String> REGISTRATION_ATTACHMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationAttachmentArn").getter(CreateRegistrationAttachmentResponse.getter(CreateRegistrationAttachmentResponse::registrationAttachmentArn)).setter(CreateRegistrationAttachmentResponse.setter(Builder::registrationAttachmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachmentArn").build()}).build();
    private static final SdkField<String> REGISTRATION_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrationAttachmentId").getter(CreateRegistrationAttachmentResponse.getter(CreateRegistrationAttachmentResponse::registrationAttachmentId)).setter(CreateRegistrationAttachmentResponse.setter(Builder::registrationAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationAttachmentId").build()}).build();
    private static final SdkField<String> ATTACHMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentStatus").getter(CreateRegistrationAttachmentResponse.getter(CreateRegistrationAttachmentResponse::attachmentStatusAsString)).setter(CreateRegistrationAttachmentResponse.setter(Builder::attachmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentStatus").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRegistrationAttachmentResponse.getter(CreateRegistrationAttachmentResponse::tags)).setter(CreateRegistrationAttachmentResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(CreateRegistrationAttachmentResponse.getter(CreateRegistrationAttachmentResponse::createdTimestamp)).setter(CreateRegistrationAttachmentResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_ATTACHMENT_ARN_FIELD, REGISTRATION_ATTACHMENT_ID_FIELD, ATTACHMENT_STATUS_FIELD, TAGS_FIELD, CREATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRegistrationAttachmentResponse.memberNameToFieldInitializer();
    private final String registrationAttachmentArn;
    private final String registrationAttachmentId;
    private final String attachmentStatus;
    private final List<Tag> tags;
    private final Instant createdTimestamp;

    private CreateRegistrationAttachmentResponse(BuilderImpl builder) {
        super(builder);
        this.registrationAttachmentArn = builder.registrationAttachmentArn;
        this.registrationAttachmentId = builder.registrationAttachmentId;
        this.attachmentStatus = builder.attachmentStatus;
        this.tags = builder.tags;
        this.createdTimestamp = builder.createdTimestamp;
    }

    public final String registrationAttachmentArn() {
        return this.registrationAttachmentArn;
    }

    public final String registrationAttachmentId() {
        return this.registrationAttachmentId;
    }

    public final AttachmentStatus attachmentStatus() {
        return AttachmentStatus.fromValue(this.attachmentStatus);
    }

    public final String attachmentStatusAsString() {
        return this.attachmentStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationAttachmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRegistrationAttachmentResponse)) {
            return false;
        }
        CreateRegistrationAttachmentResponse other = (CreateRegistrationAttachmentResponse)((Object)obj);
        return Objects.equals(this.registrationAttachmentArn(), other.registrationAttachmentArn()) && Objects.equals(this.registrationAttachmentId(), other.registrationAttachmentId()) && Objects.equals(this.attachmentStatusAsString(), other.attachmentStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRegistrationAttachmentResponse").add("RegistrationAttachmentArn", (Object)this.registrationAttachmentArn()).add("RegistrationAttachmentId", (Object)this.registrationAttachmentId()).add("AttachmentStatus", (Object)this.attachmentStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("CreatedTimestamp", (Object)this.createdTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationAttachmentArn": {
                return Optional.ofNullable(clazz.cast(this.registrationAttachmentArn()));
            }
            case "RegistrationAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.registrationAttachmentId()));
            }
            case "AttachmentStatus": {
                return Optional.ofNullable(clazz.cast(this.attachmentStatusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegistrationAttachmentArn", REGISTRATION_ATTACHMENT_ARN_FIELD);
        map.put("RegistrationAttachmentId", REGISTRATION_ATTACHMENT_ID_FIELD);
        map.put("AttachmentStatus", ATTACHMENT_STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRegistrationAttachmentResponse, T> g) {
        return obj -> g.apply((CreateRegistrationAttachmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Response.BuilderImpl
    implements Builder {
        private String registrationAttachmentArn;
        private String registrationAttachmentId;
        private String attachmentStatus;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant createdTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRegistrationAttachmentResponse model) {
            super(model);
            this.registrationAttachmentArn(model.registrationAttachmentArn);
            this.registrationAttachmentId(model.registrationAttachmentId);
            this.attachmentStatus(model.attachmentStatus);
            this.tags(model.tags);
            this.createdTimestamp(model.createdTimestamp);
        }

        public final String getRegistrationAttachmentArn() {
            return this.registrationAttachmentArn;
        }

        public final void setRegistrationAttachmentArn(String registrationAttachmentArn) {
            this.registrationAttachmentArn = registrationAttachmentArn;
        }

        @Override
        public final Builder registrationAttachmentArn(String registrationAttachmentArn) {
            this.registrationAttachmentArn = registrationAttachmentArn;
            return this;
        }

        public final String getRegistrationAttachmentId() {
            return this.registrationAttachmentId;
        }

        public final void setRegistrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
        }

        @Override
        public final Builder registrationAttachmentId(String registrationAttachmentId) {
            this.registrationAttachmentId = registrationAttachmentId;
            return this;
        }

        public final String getAttachmentStatus() {
            return this.attachmentStatus;
        }

        public final void setAttachmentStatus(String attachmentStatus) {
            this.attachmentStatus = attachmentStatus;
        }

        @Override
        public final Builder attachmentStatus(String attachmentStatus) {
            this.attachmentStatus = attachmentStatus;
            return this;
        }

        @Override
        public final Builder attachmentStatus(AttachmentStatus attachmentStatus) {
            this.attachmentStatus(attachmentStatus == null ? null : attachmentStatus.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Override
        public CreateRegistrationAttachmentResponse build() {
            return new CreateRegistrationAttachmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRegistrationAttachmentResponse> {
        public Builder registrationAttachmentArn(String var1);

        public Builder registrationAttachmentId(String var1);

        public Builder attachmentStatus(String var1);

        public Builder attachmentStatus(AttachmentStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder createdTimestamp(Instant var1);
    }
}

