/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.privatenetworks.model.CommitmentConfiguration;
import software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderedResourceDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrderedResourceDefinition> {
    private static final SdkField<CommitmentConfiguration> COMMITMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("commitmentConfiguration").getter(OrderedResourceDefinition.getter(OrderedResourceDefinition::commitmentConfiguration)).setter(OrderedResourceDefinition.setter(Builder::commitmentConfiguration)).constructor(CommitmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentConfiguration").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("count").getter(OrderedResourceDefinition.getter(OrderedResourceDefinition::count)).setter(OrderedResourceDefinition.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(OrderedResourceDefinition.getter(OrderedResourceDefinition::typeAsString)).setter(OrderedResourceDefinition.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMITMENT_CONFIGURATION_FIELD, COUNT_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final CommitmentConfiguration commitmentConfiguration;
    private final Integer count;
    private final String type;

    private OrderedResourceDefinition(BuilderImpl builder) {
        this.commitmentConfiguration = builder.commitmentConfiguration;
        this.count = builder.count;
        this.type = builder.type;
    }

    public final CommitmentConfiguration commitmentConfiguration() {
        return this.commitmentConfiguration;
    }

    public final Integer count() {
        return this.count;
    }

    public final NetworkResourceDefinitionType type() {
        return NetworkResourceDefinitionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderedResourceDefinition)) {
            return false;
        }
        OrderedResourceDefinition other = (OrderedResourceDefinition)obj;
        return Objects.equals(this.commitmentConfiguration(), other.commitmentConfiguration()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OrderedResourceDefinition").add("CommitmentConfiguration", (Object)this.commitmentConfiguration()).add("Count", (Object)this.count()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.commitmentConfiguration()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrderedResourceDefinition, T> g) {
        return obj -> g.apply((OrderedResourceDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CommitmentConfiguration commitmentConfiguration;
        private Integer count;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderedResourceDefinition model) {
            this.commitmentConfiguration(model.commitmentConfiguration);
            this.count(model.count);
            this.type(model.type);
        }

        public final CommitmentConfiguration.Builder getCommitmentConfiguration() {
            return this.commitmentConfiguration != null ? this.commitmentConfiguration.toBuilder() : null;
        }

        public final void setCommitmentConfiguration(CommitmentConfiguration.BuilderImpl commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration != null ? commitmentConfiguration.build() : null;
        }

        @Override
        public final Builder commitmentConfiguration(CommitmentConfiguration commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkResourceDefinitionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public OrderedResourceDefinition build() {
            return new OrderedResourceDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrderedResourceDefinition> {
        public Builder commitmentConfiguration(CommitmentConfiguration var1);

        default public Builder commitmentConfiguration(Consumer<CommitmentConfiguration.Builder> commitmentConfiguration) {
            return this.commitmentConfiguration((CommitmentConfiguration)((CommitmentConfiguration.Builder)CommitmentConfiguration.builder().applyMutation(commitmentConfiguration)).build());
        }

        public Builder count(Integer var1);

        public Builder type(String var1);

        public Builder type(NetworkResourceDefinitionType var1);
    }
}

