/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.GetTextDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetTextDetectionResponse;

public class GetTextDetectionPublisher
implements SdkPublisher<GetTextDetectionResponse> {
    private final RekognitionAsyncClient client;
    private final GetTextDetectionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTextDetectionPublisher(RekognitionAsyncClient client, GetTextDetectionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTextDetectionPublisher(RekognitionAsyncClient client, GetTextDetectionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTextDetectionResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetTextDetectionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetTextDetectionResponseFetcher
    implements AsyncPageFetcher<GetTextDetectionResponse> {
        private GetTextDetectionResponseFetcher() {
        }

        public boolean hasNextPage(GetTextDetectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetTextDetectionResponse> nextPage(GetTextDetectionResponse previousPage) {
            if (previousPage == null) {
                return GetTextDetectionPublisher.this.client.getTextDetection(GetTextDetectionPublisher.this.firstRequest);
            }
            return GetTextDetectionPublisher.this.client.getTextDetection((GetTextDetectionRequest)((Object)GetTextDetectionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

