/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty;
import software.amazon.awssdk.services.resourceexplorer2.model.IncludedPropertyListCopier;
import software.amazon.awssdk.services.resourceexplorer2.model.SearchFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class View
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, View> {
    private static final SdkField<SearchFilter> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(View.getter(View::filters)).setter(View.setter(Builder::filters)).constructor(SearchFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<List<IncludedProperty>> INCLUDED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IncludedProperties").getter(View.getter(View::includedProperties)).setter(View.setter(Builder::includedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncludedProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(View.getter(View::lastUpdatedAt)).setter(View.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(View.getter(View::owner)).setter(View.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(View.getter(View::scope)).setter(View.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<String> VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewArn").getter(View.getter(View::viewArn)).setter(View.setter(Builder::viewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, INCLUDED_PROPERTIES_FIELD, LAST_UPDATED_AT_FIELD, OWNER_FIELD, SCOPE_FIELD, VIEW_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Filters", FILTERS_FIELD);
            this.put("IncludedProperties", INCLUDED_PROPERTIES_FIELD);
            this.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
            this.put("Owner", OWNER_FIELD);
            this.put("Scope", SCOPE_FIELD);
            this.put("ViewArn", VIEW_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SearchFilter filters;
    private final List<IncludedProperty> includedProperties;
    private final Instant lastUpdatedAt;
    private final String owner;
    private final String scope;
    private final String viewArn;

    private View(BuilderImpl builder) {
        this.filters = builder.filters;
        this.includedProperties = builder.includedProperties;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.owner = builder.owner;
        this.scope = builder.scope;
        this.viewArn = builder.viewArn;
    }

    public final SearchFilter filters() {
        return this.filters;
    }

    public final boolean hasIncludedProperties() {
        return this.includedProperties != null && !(this.includedProperties instanceof SdkAutoConstructList);
    }

    public final List<IncludedProperty> includedProperties() {
        return this.includedProperties;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String owner() {
        return this.owner;
    }

    public final String scope() {
        return this.scope;
    }

    public final String viewArn() {
        return this.viewArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludedProperties() ? this.includedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof View)) {
            return false;
        }
        View other = (View)obj;
        return Objects.equals(this.filters(), other.filters()) && this.hasIncludedProperties() == other.hasIncludedProperties() && Objects.equals(this.includedProperties(), other.includedProperties()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.viewArn(), other.viewArn());
    }

    public final String toString() {
        return ToString.builder((String)"View").add("Filters", (Object)(this.filters() == null ? null : "*** Sensitive Data Redacted ***")).add("IncludedProperties", this.hasIncludedProperties() ? this.includedProperties() : null).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Owner", (Object)this.owner()).add("Scope", (Object)this.scope()).add("ViewArn", (Object)this.viewArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "IncludedProperties": {
                return Optional.ofNullable(clazz.cast(this.includedProperties()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "ViewArn": {
                return Optional.ofNullable(clazz.cast(this.viewArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<View, T> g) {
        return obj -> g.apply((View)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SearchFilter filters;
        private List<IncludedProperty> includedProperties = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdatedAt;
        private String owner;
        private String scope;
        private String viewArn;

        private BuilderImpl() {
        }

        private BuilderImpl(View model) {
            this.filters(model.filters);
            this.includedProperties(model.includedProperties);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.owner(model.owner);
            this.scope(model.scope);
            this.viewArn(model.viewArn);
        }

        public final SearchFilter.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(SearchFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchFilter filters) {
            this.filters = filters;
            return this;
        }

        public final List<IncludedProperty.Builder> getIncludedProperties() {
            List<IncludedProperty.Builder> result = IncludedPropertyListCopier.copyToBuilder(this.includedProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludedProperties(Collection<IncludedProperty.BuilderImpl> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copyFromBuilder(includedProperties);
        }

        @Override
        public final Builder includedProperties(Collection<IncludedProperty> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copy(includedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(IncludedProperty ... includedProperties) {
            this.includedProperties(Arrays.asList(includedProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(Consumer<IncludedProperty.Builder> ... includedProperties) {
            this.includedProperties(Stream.of(includedProperties).map(c -> (IncludedProperty)((IncludedProperty.Builder)IncludedProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final String getViewArn() {
            return this.viewArn;
        }

        public final void setViewArn(String viewArn) {
            this.viewArn = viewArn;
        }

        @Override
        public final Builder viewArn(String viewArn) {
            this.viewArn = viewArn;
            return this;
        }

        public View build() {
            return new View(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, View> {
        public Builder filters(SearchFilter var1);

        default public Builder filters(Consumer<SearchFilter.Builder> filters) {
            return this.filters((SearchFilter)((SearchFilter.Builder)SearchFilter.builder().applyMutation(filters)).build());
        }

        public Builder includedProperties(Collection<IncludedProperty> var1);

        public Builder includedProperties(IncludedProperty ... var1);

        public Builder includedProperties(Consumer<IncludedProperty.Builder> ... var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder owner(String var1);

        public Builder scope(String var1);

        public Builder viewArn(String var1);
    }
}

