/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListViewsResponse;

public class ListViewsPublisher
implements SdkPublisher<ListViewsResponse> {
    private final ResourceExplorer2AsyncClient client;
    private final ListViewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListViewsPublisher(ResourceExplorer2AsyncClient client, ListViewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListViewsPublisher(ResourceExplorer2AsyncClient client, ListViewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListViewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListViewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> views() {
        Function<ListViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.views() != null) {
                return response.views().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListViewsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListViewsResponseFetcher
    implements AsyncPageFetcher<ListViewsResponse> {
        private ListViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListViewsResponse> nextPage(ListViewsResponse previousPage) {
            if (previousPage == null) {
                return ListViewsPublisher.this.client.listViews(ListViewsPublisher.this.firstRequest);
            }
            return ListViewsPublisher.this.client.listViews((ListViewsRequest)((Object)ListViewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

