/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListResolverQueryLogConfigsResponse;
import software.amazon.awssdk.services.route53resolver.model.ResolverQueryLogConfig;

public class ListResolverQueryLogConfigsIterable
implements SdkIterable<ListResolverQueryLogConfigsResponse> {
    private final Route53ResolverClient client;
    private final ListResolverQueryLogConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolverQueryLogConfigsIterable(Route53ResolverClient client, ListResolverQueryLogConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResolverQueryLogConfigsResponseFetcher();
    }

    public Iterator<ListResolverQueryLogConfigsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResolverQueryLogConfig> resolverQueryLogConfigs() {
        Function<ListResolverQueryLogConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolverQueryLogConfigs() != null) {
                return response.resolverQueryLogConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResolverQueryLogConfigsResponseFetcher
    implements SyncPageFetcher<ListResolverQueryLogConfigsResponse> {
        private ListResolverQueryLogConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListResolverQueryLogConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolverQueryLogConfigsResponse nextPage(ListResolverQueryLogConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListResolverQueryLogConfigsIterable.this.client.listResolverQueryLogConfigs(ListResolverQueryLogConfigsIterable.this.firstRequest);
            }
            return ListResolverQueryLogConfigsIterable.this.client.listResolverQueryLogConfigs((ListResolverQueryLogConfigsRequest)((Object)ListResolverQueryLogConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

