/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.handlers;

import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.AwsExecutionAttributes;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.regions.Region;
import software.amazon.awssdk.services.s3.BucketUtils;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

public class CreateBucketInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest sdkRequest = context.request();
        if (sdkRequest instanceof CreateBucketRequest) {
            CreateBucketRequest request = (CreateBucketRequest)sdkRequest;
            this.validateBucketNameIsS3Compatible(request.bucket());
            if (request.createBucketConfiguration() == null || request.createBucketConfiguration().locationConstraint() == null) {
                Region region = (Region)executionAttributes.getAttribute(AwsExecutionAttributes.AWS_REGION);
                sdkRequest = (SdkRequest)request.toBuilder().createBucketConfiguration(this.toLocationConstraint(region)).build();
            }
        }
        return sdkRequest;
    }

    private CreateBucketConfiguration toLocationConstraint(Region region) {
        if (region.equals((Object)Region.US_EAST_1)) {
            return null;
        }
        return (CreateBucketConfiguration)CreateBucketConfiguration.builder().locationConstraint(region.value()).build();
    }

    private void validateBucketNameIsS3Compatible(String bucketName) {
        BucketUtils.isValidDnsBucketName(bucketName, true);
    }
}

