/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudFunctionConfiguration
implements ToCopyableBuilder<Builder, CloudFunctionConfiguration> {
    private final String id;
    private final String event;
    private final List<String> events;
    private final String cloudFunction;
    private final String invocationRole;

    private CloudFunctionConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.event = builder.event;
        this.events = builder.events;
        this.cloudFunction = builder.cloudFunction;
        this.invocationRole = builder.invocationRole;
    }

    public String id() {
        return this.id;
    }

    public Event event() {
        return Event.fromValue(this.event);
    }

    public String eventString() {
        return this.event;
    }

    public List<Event> events() {
        return TypeConverter.convert(this.events, Event::fromValue);
    }

    public List<String> eventsStrings() {
        return this.events;
    }

    public String cloudFunction() {
        return this.cloudFunction;
    }

    public String invocationRole() {
        return this.invocationRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.eventString() == null ? 0 : this.eventString().hashCode());
        hashCode = 31 * hashCode + (this.eventsStrings() == null ? 0 : this.eventsStrings().hashCode());
        hashCode = 31 * hashCode + (this.cloudFunction() == null ? 0 : this.cloudFunction().hashCode());
        hashCode = 31 * hashCode + (this.invocationRole() == null ? 0 : this.invocationRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFunctionConfiguration)) {
            return false;
        }
        CloudFunctionConfiguration other = (CloudFunctionConfiguration)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.eventString() == null ^ this.eventString() == null) {
            return false;
        }
        if (other.eventString() != null && !other.eventString().equals(this.eventString())) {
            return false;
        }
        if (other.eventsStrings() == null ^ this.eventsStrings() == null) {
            return false;
        }
        if (other.eventsStrings() != null && !other.eventsStrings().equals(this.eventsStrings())) {
            return false;
        }
        if (other.cloudFunction() == null ^ this.cloudFunction() == null) {
            return false;
        }
        if (other.cloudFunction() != null && !other.cloudFunction().equals(this.cloudFunction())) {
            return false;
        }
        if (other.invocationRole() == null ^ this.invocationRole() == null) {
            return false;
        }
        return other.invocationRole() == null || other.invocationRole().equals(this.invocationRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.eventString() != null) {
            sb.append("Event: ").append(this.eventString()).append(",");
        }
        if (this.eventsStrings() != null) {
            sb.append("Events: ").append(this.eventsStrings()).append(",");
        }
        if (this.cloudFunction() != null) {
            sb.append("CloudFunction: ").append(this.cloudFunction()).append(",");
        }
        if (this.invocationRole() != null) {
            sb.append("InvocationRole: ").append(this.invocationRole()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Event": {
                return Optional.of(clazz.cast(this.eventString()));
            }
            case "Events": {
                return Optional.of(clazz.cast(this.eventsStrings()));
            }
            case "CloudFunction": {
                return Optional.of(clazz.cast(this.cloudFunction()));
            }
            case "InvocationRole": {
                return Optional.of(clazz.cast(this.invocationRole()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String event;
        private List<String> events;
        private String cloudFunction;
        private String invocationRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFunctionConfiguration model) {
            this.id(model.id);
            this.event(model.event);
            this.events(model.events);
            this.cloudFunction(model.cloudFunction);
            this.invocationRole(model.invocationRole);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEvent() {
            return this.event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final String getCloudFunction() {
            return this.cloudFunction;
        }

        @Override
        public final Builder cloudFunction(String cloudFunction) {
            this.cloudFunction = cloudFunction;
            return this;
        }

        public final void setCloudFunction(String cloudFunction) {
            this.cloudFunction = cloudFunction;
        }

        public final String getInvocationRole() {
            return this.invocationRole;
        }

        @Override
        public final Builder invocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
            return this;
        }

        public final void setInvocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
        }

        public CloudFunctionConfiguration build() {
            return new CloudFunctionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudFunctionConfiguration> {
        public Builder id(String var1);

        public Builder event(String var1);

        public Builder event(Event var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder cloudFunction(String var1);

        public Builder invocationRole(String var1);
    }
}

