/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.CommonPrefixListCopier;
import software.amazon.awssdk.services.s3.model.EncodingType;
import software.amazon.awssdk.services.s3.model.ObjectListCopier;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListObjectsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListObjectsResponse> {
    private final Boolean isTruncated;
    private final String marker;
    private final String nextMarker;
    private final List<S3Object> contents;
    private final String name;
    private final String prefix;
    private final String delimiter;
    private final Integer maxKeys;
    private final List<CommonPrefix> commonPrefixes;
    private final String encodingType;

    private ListObjectsResponse(BuilderImpl builder) {
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.contents = builder.contents;
        this.name = builder.name;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.maxKeys = builder.maxKeys;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public String nextMarker() {
        return this.nextMarker;
    }

    public List<S3Object> contents() {
        return this.contents;
    }

    public String name() {
        return this.name;
    }

    public String prefix() {
        return this.prefix;
    }

    public String delimiter() {
        return this.delimiter;
    }

    public Integer maxKeys() {
        return this.maxKeys;
    }

    public List<CommonPrefix> commonPrefixes() {
        return this.commonPrefixes;
    }

    public EncodingType encodingType() {
        return EncodingType.fromValue(this.encodingType);
    }

    public String encodingTypeString() {
        return this.encodingType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.nextMarker() == null ? 0 : this.nextMarker().hashCode());
        hashCode = 31 * hashCode + (this.contents() == null ? 0 : this.contents().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.delimiter() == null ? 0 : this.delimiter().hashCode());
        hashCode = 31 * hashCode + (this.maxKeys() == null ? 0 : this.maxKeys().hashCode());
        hashCode = 31 * hashCode + (this.commonPrefixes() == null ? 0 : this.commonPrefixes().hashCode());
        hashCode = 31 * hashCode + (this.encodingTypeString() == null ? 0 : this.encodingTypeString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsResponse)) {
            return false;
        }
        ListObjectsResponse other = (ListObjectsResponse)((Object)obj);
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.contents() == null ^ this.contents() == null) {
            return false;
        }
        if (other.contents() != null && !other.contents().equals(this.contents())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.maxKeys() == null ^ this.maxKeys() == null) {
            return false;
        }
        if (other.maxKeys() != null && !other.maxKeys().equals(this.maxKeys())) {
            return false;
        }
        if (other.commonPrefixes() == null ^ this.commonPrefixes() == null) {
            return false;
        }
        if (other.commonPrefixes() != null && !other.commonPrefixes().equals(this.commonPrefixes())) {
            return false;
        }
        if (other.encodingTypeString() == null ^ this.encodingTypeString() == null) {
            return false;
        }
        return other.encodingTypeString() == null || other.encodingTypeString().equals(this.encodingTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.nextMarker() != null) {
            sb.append("NextMarker: ").append(this.nextMarker()).append(",");
        }
        if (this.contents() != null) {
            sb.append("Contents: ").append(this.contents()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.delimiter() != null) {
            sb.append("Delimiter: ").append(this.delimiter()).append(",");
        }
        if (this.maxKeys() != null) {
            sb.append("MaxKeys: ").append(this.maxKeys()).append(",");
        }
        if (this.commonPrefixes() != null) {
            sb.append("CommonPrefixes: ").append(this.commonPrefixes()).append(",");
        }
        if (this.encodingTypeString() != null) {
            sb.append("EncodingType: ").append(this.encodingTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IsTruncated": {
                return Optional.of(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "NextMarker": {
                return Optional.of(clazz.cast(this.nextMarker()));
            }
            case "Contents": {
                return Optional.of(clazz.cast(this.contents()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Prefix": {
                return Optional.of(clazz.cast(this.prefix()));
            }
            case "Delimiter": {
                return Optional.of(clazz.cast(this.delimiter()));
            }
            case "MaxKeys": {
                return Optional.of(clazz.cast(this.maxKeys()));
            }
            case "CommonPrefixes": {
                return Optional.of(clazz.cast(this.commonPrefixes()));
            }
            case "EncodingType": {
                return Optional.of(clazz.cast(this.encodingTypeString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean isTruncated;
        private String marker;
        private String nextMarker;
        private List<S3Object> contents;
        private String name;
        private String prefix;
        private String delimiter;
        private Integer maxKeys;
        private List<CommonPrefix> commonPrefixes;
        private String encodingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectsResponse model) {
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
            this.nextMarker(model.nextMarker);
            this.contents(model.contents);
            this.name(model.name);
            this.prefix(model.prefix);
            this.delimiter(model.delimiter);
            this.maxKeys(model.maxKeys);
            this.commonPrefixes(model.commonPrefixes);
            this.encodingType(model.encodingType);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<S3Object.Builder> getContents() {
            return this.contents != null ? (Collection)this.contents.stream().map(S3Object::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contents(Collection<S3Object> contents) {
            this.contents = ObjectListCopier.copy(contents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contents(S3Object ... contents) {
            this.contents(Arrays.asList(contents));
            return this;
        }

        public final void setContents(Collection<S3Object.BuilderImpl> contents) {
            this.contents = ObjectListCopier.copyFromBuilder(contents);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Integer getMaxKeys() {
            return this.maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final Collection<CommonPrefix.Builder> getCommonPrefixes() {
            return this.commonPrefixes != null ? (Collection)this.commonPrefixes.stream().map(CommonPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(CommonPrefix ... commonPrefixes) {
            this.commonPrefixes(Arrays.asList(commonPrefixes));
            return this;
        }

        public final void setCommonPrefixes(Collection<CommonPrefix.BuilderImpl> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copyFromBuilder(commonPrefixes);
        }

        public final String getEncodingType() {
            return this.encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public ListObjectsResponse build() {
            return new ListObjectsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListObjectsResponse> {
        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);

        public Builder nextMarker(String var1);

        public Builder contents(Collection<S3Object> var1);

        public Builder contents(S3Object ... var1);

        public Builder name(String var1);

        public Builder prefix(String var1);

        public Builder delimiter(String var1);

        public Builder maxKeys(Integer var1);

        public Builder commonPrefixes(Collection<CommonPrefix> var1);

        public Builder commonPrefixes(CommonPrefix ... var1);

        public Builder encodingType(String var1);

        public Builder encodingType(EncodingType var1);
    }
}

