/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import software.amazon.awssdk.services.s3.model.MetricsFilter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetricsConfiguration
implements ToCopyableBuilder<Builder, MetricsConfiguration> {
    private final String id;
    private final MetricsFilter filter;

    private MetricsConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.filter = builder.filter;
    }

    public String id() {
        return this.id;
    }

    public MetricsFilter filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.filter() == null ? 0 : this.filter().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsConfiguration)) {
            return false;
        }
        MetricsConfiguration other = (MetricsConfiguration)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.filter() == null ^ this.filter() == null) {
            return false;
        }
        return other.filter() == null || other.filter().equals(this.filter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private MetricsFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsConfiguration model) {
            this.id(model.id);
            this.filter(model.filter);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MetricsFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(MetricsFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(MetricsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public MetricsConfiguration build() {
            return new MetricsConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricsConfiguration> {
        public Builder id(String var1);

        public Builder filter(MetricsFilter var1);
    }
}

