/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.BucketLoggingStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketLoggingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutBucketLoggingRequest> {
    private final String bucket;
    private final BucketLoggingStatus bucketLoggingStatus;
    private final String contentMD5;

    private PutBucketLoggingRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.bucketLoggingStatus = builder.bucketLoggingStatus;
        this.contentMD5 = builder.contentMD5;
    }

    public String bucket() {
        return this.bucket;
    }

    public BucketLoggingStatus bucketLoggingStatus() {
        return this.bucketLoggingStatus;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.bucketLoggingStatus() == null ? 0 : this.bucketLoggingStatus().hashCode());
        hashCode = 31 * hashCode + (this.contentMD5() == null ? 0 : this.contentMD5().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLoggingRequest)) {
            return false;
        }
        PutBucketLoggingRequest other = (PutBucketLoggingRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.bucketLoggingStatus() == null ^ this.bucketLoggingStatus() == null) {
            return false;
        }
        if (other.bucketLoggingStatus() != null && !other.bucketLoggingStatus().equals(this.bucketLoggingStatus())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        return other.contentMD5() == null || other.contentMD5().equals(this.contentMD5());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.bucketLoggingStatus() != null) {
            sb.append("BucketLoggingStatus: ").append(this.bucketLoggingStatus()).append(",");
        }
        if (this.contentMD5() != null) {
            sb.append("ContentMD5: ").append(this.contentMD5()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "BucketLoggingStatus": {
                return Optional.of(clazz.cast(this.bucketLoggingStatus()));
            }
            case "ContentMD5": {
                return Optional.of(clazz.cast(this.contentMD5()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private BucketLoggingStatus bucketLoggingStatus;
        private String contentMD5;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLoggingRequest model) {
            this.bucket(model.bucket);
            this.bucketLoggingStatus(model.bucketLoggingStatus);
            this.contentMD5(model.contentMD5);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final BucketLoggingStatus.Builder getBucketLoggingStatus() {
            return this.bucketLoggingStatus != null ? this.bucketLoggingStatus.toBuilder() : null;
        }

        @Override
        public final Builder bucketLoggingStatus(BucketLoggingStatus bucketLoggingStatus) {
            this.bucketLoggingStatus = bucketLoggingStatus;
            return this;
        }

        public final void setBucketLoggingStatus(BucketLoggingStatus.BuilderImpl bucketLoggingStatus) {
            this.bucketLoggingStatus = bucketLoggingStatus != null ? bucketLoggingStatus.build() : null;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public PutBucketLoggingRequest build() {
            return new PutBucketLoggingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutBucketLoggingRequest> {
        public Builder bucket(String var1);

        public Builder bucketLoggingStatus(BucketLoggingStatus var1);

        public Builder contentMD5(String var1);
    }
}

