/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.TagSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Tagging
implements ToCopyableBuilder<Builder, Tagging> {
    private final List<Tag> tagSet;

    private Tagging(BuilderImpl builder) {
        this.tagSet = builder.tagSet;
    }

    public List<Tag> tagSet() {
        return this.tagSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tagSet() == null ? 0 : this.tagSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tagging)) {
            return false;
        }
        Tagging other = (Tagging)obj;
        if (other.tagSet() == null ^ this.tagSet() == null) {
            return false;
        }
        return other.tagSet() == null || other.tagSet().equals(this.tagSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tagSet() != null) {
            sb.append("TagSet: ").append(this.tagSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagSet": {
                return Optional.of(clazz.cast(this.tagSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Tag> tagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(Tagging model) {
            this.tagSet(model.tagSet);
        }

        public final Collection<Tag.Builder> getTagSet() {
            return this.tagSet != null ? (Collection)this.tagSet.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSet(Collection<Tag> tagSet) {
            this.tagSet = TagSetCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Tag ... tagSet) {
            this.tagSet(Arrays.asList(tagSet));
            return this;
        }

        public final void setTagSet(Collection<Tag.BuilderImpl> tagSet) {
            this.tagSet = TagSetCopier.copyFromBuilder(tagSet);
        }

        public Tagging build() {
            return new Tagging(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Tagging> {
        public Builder tagSet(Collection<Tag> var1);

        public Builder tagSet(Tag ... var1);
    }
}

