/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadPartRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UploadPartRequest> {
    private final String bucket;
    private final Long contentLength;
    private final String contentMD5;
    private final String key;
    private final Integer partNumber;
    private final String uploadId;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKey;
    private final String sseCustomerKeyMD5;
    private final String requestPayer;

    private UploadPartRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.contentLength = builder.contentLength;
        this.contentMD5 = builder.contentMD5;
        this.key = builder.key;
        this.partNumber = builder.partNumber;
        this.uploadId = builder.uploadId;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
    }

    public String bucket() {
        return this.bucket;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public String key() {
        return this.key;
    }

    public Integer partNumber() {
        return this.partNumber;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKey() {
        return this.sseCustomerKey;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(this.requestPayer);
    }

    public String requestPayerString() {
        return this.requestPayer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.contentLength() == null ? 0 : this.contentLength().hashCode());
        hashCode = 31 * hashCode + (this.contentMD5() == null ? 0 : this.contentMD5().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.partNumber() == null ? 0 : this.partNumber().hashCode());
        hashCode = 31 * hashCode + (this.uploadId() == null ? 0 : this.uploadId().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerAlgorithm() == null ? 0 : this.sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerKey() == null ? 0 : this.sseCustomerKey().hashCode());
        hashCode = 31 * hashCode + (this.sseCustomerKeyMD5() == null ? 0 : this.sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + (this.requestPayerString() == null ? 0 : this.requestPayerString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadPartRequest)) {
            return false;
        }
        UploadPartRequest other = (UploadPartRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.contentLength() == null ^ this.contentLength() == null) {
            return false;
        }
        if (other.contentLength() != null && !other.contentLength().equals(this.contentLength())) {
            return false;
        }
        if (other.contentMD5() == null ^ this.contentMD5() == null) {
            return false;
        }
        if (other.contentMD5() != null && !other.contentMD5().equals(this.contentMD5())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.partNumber() == null ^ this.partNumber() == null) {
            return false;
        }
        if (other.partNumber() != null && !other.partNumber().equals(this.partNumber())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKey() == null ^ this.sseCustomerKey() == null) {
            return false;
        }
        if (other.sseCustomerKey() != null && !other.sseCustomerKey().equals(this.sseCustomerKey())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.requestPayerString() == null ^ this.requestPayerString() == null) {
            return false;
        }
        return other.requestPayerString() == null || other.requestPayerString().equals(this.requestPayerString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.contentLength() != null) {
            sb.append("ContentLength: ").append(this.contentLength()).append(",");
        }
        if (this.contentMD5() != null) {
            sb.append("ContentMD5: ").append(this.contentMD5()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.partNumber() != null) {
            sb.append("PartNumber: ").append(this.partNumber()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(this.sseCustomerAlgorithm()).append(",");
        }
        if (this.sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(this.sseCustomerKey()).append(",");
        }
        if (this.sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(this.sseCustomerKeyMD5()).append(",");
        }
        if (this.requestPayerString() != null) {
            sb.append("RequestPayer: ").append(this.requestPayerString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "ContentLength": {
                return Optional.of(clazz.cast(this.contentLength()));
            }
            case "ContentMD5": {
                return Optional.of(clazz.cast(this.contentMD5()));
            }
            case "Key": {
                return Optional.of(clazz.cast(this.key()));
            }
            case "PartNumber": {
                return Optional.of(clazz.cast(this.partNumber()));
            }
            case "UploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
            case "SSECustomerAlgorithm": {
                return Optional.of(clazz.cast(this.sseCustomerAlgorithm()));
            }
            case "SSECustomerKey": {
                return Optional.of(clazz.cast(this.sseCustomerKey()));
            }
            case "SSECustomerKeyMD5": {
                return Optional.of(clazz.cast(this.sseCustomerKeyMD5()));
            }
            case "RequestPayer": {
                return Optional.of(clazz.cast(this.requestPayerString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private Long contentLength;
        private String contentMD5;
        private String key;
        private Integer partNumber;
        private String uploadId;
        private String sseCustomerAlgorithm;
        private String sseCustomerKey;
        private String sseCustomerKeyMD5;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadPartRequest model) {
            this.bucket(model.bucket);
            this.contentLength(model.contentLength);
            this.contentMD5(model.contentMD5);
            this.key(model.key);
            this.partNumber(model.partNumber);
            this.uploadId(model.uploadId);
            this.sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            this.sseCustomerKey(model.sseCustomerKey);
            this.sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            this.requestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return this.sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public UploadPartRequest build() {
            return new UploadPartRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UploadPartRequest> {
        public Builder bucket(String var1);

        public Builder contentLength(Long var1);

        public Builder contentMD5(String var1);

        public Builder key(String var1);

        public Builder partNumber(Integer var1);

        public Builder uploadId(String var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKey(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);
    }
}

