/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.ErrorDocument;
import software.amazon.awssdk.services.s3.model.IndexDocument;
import software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo;
import software.amazon.awssdk.services.s3.model.RoutingRule;
import software.amazon.awssdk.services.s3.model.RoutingRulesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WebsiteConfiguration
implements ToCopyableBuilder<Builder, WebsiteConfiguration> {
    private final ErrorDocument errorDocument;
    private final IndexDocument indexDocument;
    private final RedirectAllRequestsTo redirectAllRequestsTo;
    private final List<RoutingRule> routingRules;

    private WebsiteConfiguration(BuilderImpl builder) {
        this.errorDocument = builder.errorDocument;
        this.indexDocument = builder.indexDocument;
        this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
        this.routingRules = builder.routingRules;
    }

    public ErrorDocument errorDocument() {
        return this.errorDocument;
    }

    public IndexDocument indexDocument() {
        return this.indexDocument;
    }

    public RedirectAllRequestsTo redirectAllRequestsTo() {
        return this.redirectAllRequestsTo;
    }

    public List<RoutingRule> routingRules() {
        return this.routingRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.errorDocument() == null ? 0 : this.errorDocument().hashCode());
        hashCode = 31 * hashCode + (this.indexDocument() == null ? 0 : this.indexDocument().hashCode());
        hashCode = 31 * hashCode + (this.redirectAllRequestsTo() == null ? 0 : this.redirectAllRequestsTo().hashCode());
        hashCode = 31 * hashCode + (this.routingRules() == null ? 0 : this.routingRules().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebsiteConfiguration)) {
            return false;
        }
        WebsiteConfiguration other = (WebsiteConfiguration)obj;
        if (other.errorDocument() == null ^ this.errorDocument() == null) {
            return false;
        }
        if (other.errorDocument() != null && !other.errorDocument().equals(this.errorDocument())) {
            return false;
        }
        if (other.indexDocument() == null ^ this.indexDocument() == null) {
            return false;
        }
        if (other.indexDocument() != null && !other.indexDocument().equals(this.indexDocument())) {
            return false;
        }
        if (other.redirectAllRequestsTo() == null ^ this.redirectAllRequestsTo() == null) {
            return false;
        }
        if (other.redirectAllRequestsTo() != null && !other.redirectAllRequestsTo().equals(this.redirectAllRequestsTo())) {
            return false;
        }
        if (other.routingRules() == null ^ this.routingRules() == null) {
            return false;
        }
        return other.routingRules() == null || other.routingRules().equals(this.routingRules());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.errorDocument() != null) {
            sb.append("ErrorDocument: ").append(this.errorDocument()).append(",");
        }
        if (this.indexDocument() != null) {
            sb.append("IndexDocument: ").append(this.indexDocument()).append(",");
        }
        if (this.redirectAllRequestsTo() != null) {
            sb.append("RedirectAllRequestsTo: ").append(this.redirectAllRequestsTo()).append(",");
        }
        if (this.routingRules() != null) {
            sb.append("RoutingRules: ").append(this.routingRules()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorDocument": {
                return Optional.of(clazz.cast(this.errorDocument()));
            }
            case "IndexDocument": {
                return Optional.of(clazz.cast(this.indexDocument()));
            }
            case "RedirectAllRequestsTo": {
                return Optional.of(clazz.cast(this.redirectAllRequestsTo()));
            }
            case "RoutingRules": {
                return Optional.of(clazz.cast(this.routingRules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ErrorDocument errorDocument;
        private IndexDocument indexDocument;
        private RedirectAllRequestsTo redirectAllRequestsTo;
        private List<RoutingRule> routingRules;

        private BuilderImpl() {
        }

        private BuilderImpl(WebsiteConfiguration model) {
            this.errorDocument(model.errorDocument);
            this.indexDocument(model.indexDocument);
            this.redirectAllRequestsTo(model.redirectAllRequestsTo);
            this.routingRules(model.routingRules);
        }

        public final ErrorDocument.Builder getErrorDocument() {
            return this.errorDocument != null ? this.errorDocument.toBuilder() : null;
        }

        @Override
        public final Builder errorDocument(ErrorDocument errorDocument) {
            this.errorDocument = errorDocument;
            return this;
        }

        public final void setErrorDocument(ErrorDocument.BuilderImpl errorDocument) {
            this.errorDocument = errorDocument != null ? errorDocument.build() : null;
        }

        public final IndexDocument.Builder getIndexDocument() {
            return this.indexDocument != null ? this.indexDocument.toBuilder() : null;
        }

        @Override
        public final Builder indexDocument(IndexDocument indexDocument) {
            this.indexDocument = indexDocument;
            return this;
        }

        public final void setIndexDocument(IndexDocument.BuilderImpl indexDocument) {
            this.indexDocument = indexDocument != null ? indexDocument.build() : null;
        }

        public final RedirectAllRequestsTo.Builder getRedirectAllRequestsTo() {
            return this.redirectAllRequestsTo != null ? this.redirectAllRequestsTo.toBuilder() : null;
        }

        @Override
        public final Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        public final void setRedirectAllRequestsTo(RedirectAllRequestsTo.BuilderImpl redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo != null ? redirectAllRequestsTo.build() : null;
        }

        public final Collection<RoutingRule.Builder> getRoutingRules() {
            return this.routingRules != null ? (Collection)this.routingRules.stream().map(RoutingRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routingRules(Collection<RoutingRule> routingRules) {
            this.routingRules = RoutingRulesCopier.copy(routingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingRules(RoutingRule ... routingRules) {
            this.routingRules(Arrays.asList(routingRules));
            return this;
        }

        public final void setRoutingRules(Collection<RoutingRule.BuilderImpl> routingRules) {
            this.routingRules = RoutingRulesCopier.copyFromBuilder(routingRules);
        }

        public WebsiteConfiguration build() {
            return new WebsiteConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebsiteConfiguration> {
        public Builder errorDocument(ErrorDocument var1);

        public Builder indexDocument(IndexDocument var1);

        public Builder redirectAllRequestsTo(RedirectAllRequestsTo var1);

        public Builder routingRules(Collection<RoutingRule> var1);

        public Builder routingRules(RoutingRule ... var1);
    }
}

