/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.AnalyticsAndOperator;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.transform.TagUnmarshaller;

public class AnalyticsAndOperatorUnmarshaller
implements Unmarshaller<AnalyticsAndOperator, StaxUnmarshallerContext> {
    private static final AnalyticsAndOperatorUnmarshaller INSTANCE = new AnalyticsAndOperatorUnmarshaller();

    public AnalyticsAndOperator unmarshall(StaxUnmarshallerContext context) throws Exception {
        AnalyticsAndOperator.Builder analyticsAndOperator;
        block6: {
            analyticsAndOperator = AnalyticsAndOperator.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    analyticsAndOperator.tags(tags);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Prefix", targetDepth)) {
                        analyticsAndOperator.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Tag", targetDepth)) continue;
                    if (tags == null) {
                        tags = new ArrayList<Tag>();
                    }
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            analyticsAndOperator.tags(tags);
        }
        return (AnalyticsAndOperator)analyticsAndOperator.build();
    }

    public static AnalyticsAndOperatorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

