/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest;

public class PutBucketPolicyRequestMarshaller
implements Marshaller<Request<PutBucketPolicyRequest>, PutBucketPolicyRequest> {
    public Request<PutBucketPolicyRequest> marshall(PutBucketPolicyRequest putBucketPolicyRequest) {
        if (putBucketPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketPolicyRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketPolicyRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putBucketPolicyRequest.contentMD5()));
        }
        String uriResourcePath = "/{Bucket}?policy";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketPolicyRequest.bucket());
        request.setResourcePath(uriResourcePath);
        String policy = putBucketPolicyRequest.policy();
        if (policy != null) {
            byte[] content = policy.getBytes(StandardCharsets.UTF_8);
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-MD5")) {
                request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])content));
            }
        }
        return request;
    }
}

