/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.JobManifestGeneratorFilter;
import software.amazon.awssdk.services.s3control.model.S3ManifestOutputLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3JobManifestGenerator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3JobManifestGenerator> {
    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedBucketOwner").getter(S3JobManifestGenerator.getter(S3JobManifestGenerator::expectedBucketOwner)).setter(S3JobManifestGenerator.setter(Builder::expectedBucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedBucketOwner").unmarshallLocationName("ExpectedBucketOwner").build()}).build();
    private static final SdkField<String> SOURCE_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBucket").getter(S3JobManifestGenerator.getter(S3JobManifestGenerator::sourceBucket)).setter(S3JobManifestGenerator.setter(Builder::sourceBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBucket").unmarshallLocationName("SourceBucket").build()}).build();
    private static final SdkField<S3ManifestOutputLocation> MANIFEST_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestOutputLocation").getter(S3JobManifestGenerator.getter(S3JobManifestGenerator::manifestOutputLocation)).setter(S3JobManifestGenerator.setter(Builder::manifestOutputLocation)).constructor(S3ManifestOutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestOutputLocation").unmarshallLocationName("ManifestOutputLocation").build()}).build();
    private static final SdkField<JobManifestGeneratorFilter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(S3JobManifestGenerator.getter(S3JobManifestGenerator::filter)).setter(S3JobManifestGenerator.setter(Builder::filter)).constructor(JobManifestGeneratorFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build();
    private static final SdkField<Boolean> ENABLE_MANIFEST_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableManifestOutput").getter(S3JobManifestGenerator.getter(S3JobManifestGenerator::enableManifestOutput)).setter(S3JobManifestGenerator.setter(Builder::enableManifestOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableManifestOutput").unmarshallLocationName("EnableManifestOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPECTED_BUCKET_OWNER_FIELD, SOURCE_BUCKET_FIELD, MANIFEST_OUTPUT_LOCATION_FIELD, FILTER_FIELD, ENABLE_MANIFEST_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3JobManifestGenerator.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String expectedBucketOwner;
    private final String sourceBucket;
    private final S3ManifestOutputLocation manifestOutputLocation;
    private final JobManifestGeneratorFilter filter;
    private final Boolean enableManifestOutput;

    private S3JobManifestGenerator(BuilderImpl builder) {
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.sourceBucket = builder.sourceBucket;
        this.manifestOutputLocation = builder.manifestOutputLocation;
        this.filter = builder.filter;
        this.enableManifestOutput = builder.enableManifestOutput;
    }

    public final String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public final String sourceBucket() {
        return this.sourceBucket;
    }

    public final S3ManifestOutputLocation manifestOutputLocation() {
        return this.manifestOutputLocation;
    }

    public final JobManifestGeneratorFilter filter() {
        return this.filter;
    }

    public final Boolean enableManifestOutput() {
        return this.enableManifestOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedBucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableManifestOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3JobManifestGenerator)) {
            return false;
        }
        S3JobManifestGenerator other = (S3JobManifestGenerator)obj;
        return Objects.equals(this.expectedBucketOwner(), other.expectedBucketOwner()) && Objects.equals(this.sourceBucket(), other.sourceBucket()) && Objects.equals(this.manifestOutputLocation(), other.manifestOutputLocation()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.enableManifestOutput(), other.enableManifestOutput());
    }

    public final String toString() {
        return ToString.builder((String)"S3JobManifestGenerator").add("ExpectedBucketOwner", (Object)this.expectedBucketOwner()).add("SourceBucket", (Object)this.sourceBucket()).add("ManifestOutputLocation", (Object)this.manifestOutputLocation()).add("Filter", (Object)this.filter()).add("EnableManifestOutput", (Object)this.enableManifestOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpectedBucketOwner": {
                return Optional.ofNullable(clazz.cast(this.expectedBucketOwner()));
            }
            case "SourceBucket": {
                return Optional.ofNullable(clazz.cast(this.sourceBucket()));
            }
            case "ManifestOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.manifestOutputLocation()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "EnableManifestOutput": {
                return Optional.ofNullable(clazz.cast(this.enableManifestOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExpectedBucketOwner", EXPECTED_BUCKET_OWNER_FIELD);
        map.put("SourceBucket", SOURCE_BUCKET_FIELD);
        map.put("ManifestOutputLocation", MANIFEST_OUTPUT_LOCATION_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("EnableManifestOutput", ENABLE_MANIFEST_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3JobManifestGenerator, T> g) {
        return obj -> g.apply((S3JobManifestGenerator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expectedBucketOwner;
        private String sourceBucket;
        private S3ManifestOutputLocation manifestOutputLocation;
        private JobManifestGeneratorFilter filter;
        private Boolean enableManifestOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(S3JobManifestGenerator model) {
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.sourceBucket(model.sourceBucket);
            this.manifestOutputLocation(model.manifestOutputLocation);
            this.filter(model.filter);
            this.enableManifestOutput(model.enableManifestOutput);
        }

        public final String getExpectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public final String getSourceBucket() {
            return this.sourceBucket;
        }

        public final void setSourceBucket(String sourceBucket) {
            this.sourceBucket = sourceBucket;
        }

        @Override
        public final Builder sourceBucket(String sourceBucket) {
            this.sourceBucket = sourceBucket;
            return this;
        }

        public final S3ManifestOutputLocation.Builder getManifestOutputLocation() {
            return this.manifestOutputLocation != null ? this.manifestOutputLocation.toBuilder() : null;
        }

        public final void setManifestOutputLocation(S3ManifestOutputLocation.BuilderImpl manifestOutputLocation) {
            this.manifestOutputLocation = manifestOutputLocation != null ? manifestOutputLocation.build() : null;
        }

        @Override
        public final Builder manifestOutputLocation(S3ManifestOutputLocation manifestOutputLocation) {
            this.manifestOutputLocation = manifestOutputLocation;
            return this;
        }

        public final JobManifestGeneratorFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(JobManifestGeneratorFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(JobManifestGeneratorFilter filter) {
            this.filter = filter;
            return this;
        }

        public final Boolean getEnableManifestOutput() {
            return this.enableManifestOutput;
        }

        public final void setEnableManifestOutput(Boolean enableManifestOutput) {
            this.enableManifestOutput = enableManifestOutput;
        }

        @Override
        public final Builder enableManifestOutput(Boolean enableManifestOutput) {
            this.enableManifestOutput = enableManifestOutput;
            return this;
        }

        public S3JobManifestGenerator build() {
            return new S3JobManifestGenerator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3JobManifestGenerator> {
        public Builder expectedBucketOwner(String var1);

        public Builder sourceBucket(String var1);

        public Builder manifestOutputLocation(S3ManifestOutputLocation var1);

        default public Builder manifestOutputLocation(Consumer<S3ManifestOutputLocation.Builder> manifestOutputLocation) {
            return this.manifestOutputLocation((S3ManifestOutputLocation)((S3ManifestOutputLocation.Builder)S3ManifestOutputLocation.builder().applyMutation(manifestOutputLocation)).build());
        }

        public Builder filter(JobManifestGeneratorFilter var1);

        default public Builder filter(Consumer<JobManifestGeneratorFilter.Builder> filter) {
            return this.filter((JobManifestGeneratorFilter)((JobManifestGeneratorFilter.Builder)JobManifestGeneratorFilter.builder().applyMutation(filter)).build());
        }

        public Builder enableManifestOutput(Boolean var1);
    }
}

