/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a Map state that was started.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MapStateStartedEventDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<MapStateStartedEventDetails.Builder, MapStateStartedEventDetails> {
    private static final SdkField<Integer> LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("length").getter(getter(MapStateStartedEventDetails::length)).setter(setter(Builder::length))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("length").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("length", LENGTH_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer length;

    private MapStateStartedEventDetails(BuilderImpl builder) {
        this.length = builder.length;
    }

    /**
     * <p>
     * The size of the array for Map state iterations.
     * </p>
     * 
     * @return The size of the array for Map state iterations.
     */
    public final Integer length() {
        return length;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(length());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapStateStartedEventDetails)) {
            return false;
        }
        MapStateStartedEventDetails other = (MapStateStartedEventDetails) obj;
        return Objects.equals(length(), other.length());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MapStateStartedEventDetails").add("Length", length()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "length":
            return Optional.ofNullable(clazz.cast(length()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MapStateStartedEventDetails, T> g) {
        return obj -> g.apply((MapStateStartedEventDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MapStateStartedEventDetails> {
        /**
         * <p>
         * The size of the array for Map state iterations.
         * </p>
         * 
         * @param length
         *        The size of the array for Map state iterations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder length(Integer length);
    }

    static final class BuilderImpl implements Builder {
        private Integer length;

        private BuilderImpl() {
        }

        private BuilderImpl(MapStateStartedEventDetails model) {
            length(model.length);
        }

        public final Integer getLength() {
            return length;
        }

        public final void setLength(Integer length) {
            this.length = length;
        }

        @Override
        public final Builder length(Integer length) {
            this.length = length;
            return this;
        }

        @Override
        public MapStateStartedEventDetails build() {
            return new MapStateStartedEventDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
