/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sfn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the routing configuration of a state machine alias. In a routing configuration, you define an
 * array of objects that specify up to two state machine versions. You also specify the percentage of traffic to be
 * routed to each version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingConfigurationListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<RoutingConfigurationListItem.Builder, RoutingConfigurationListItem> {
    private static final SdkField<String> STATE_MACHINE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateMachineVersionArn").getter(getter(RoutingConfigurationListItem::stateMachineVersionArn))
            .setter(setter(Builder::stateMachineVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateMachineVersionArn").build())
            .build();

    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("weight").getter(getter(RoutingConfigurationListItem::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STATE_MACHINE_VERSION_ARN_FIELD, WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("stateMachineVersionArn", STATE_MACHINE_VERSION_ARN_FIELD);
                    put("weight", WEIGHT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String stateMachineVersionArn;

    private final Integer weight;

    private RoutingConfigurationListItem(BuilderImpl builder) {
        this.stateMachineVersionArn = builder.stateMachineVersionArn;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing
     * configuration.
     * </p>
     * <p>
     * If you specify the ARN of a second version, it must belong to the same state machine as the first version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing
     *         configuration.</p>
     *         <p>
     *         If you specify the ARN of a second version, it must belong to the same state machine as the first
     *         version.
     */
    public final String stateMachineVersionArn() {
        return stateMachineVersionArn;
    }

    /**
     * <p>
     * The percentage of traffic you want to route to a state machine version. The sum of the weights in the routing
     * configuration must be equal to 100.
     * </p>
     * 
     * @return The percentage of traffic you want to route to a state machine version. The sum of the weights in the
     *         routing configuration must be equal to 100.
     */
    public final Integer weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateMachineVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingConfigurationListItem)) {
            return false;
        }
        RoutingConfigurationListItem other = (RoutingConfigurationListItem) obj;
        return Objects.equals(stateMachineVersionArn(), other.stateMachineVersionArn())
                && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingConfigurationListItem").add("StateMachineVersionArn", stateMachineVersionArn())
                .add("Weight", weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stateMachineVersionArn":
            return Optional.ofNullable(clazz.cast(stateMachineVersionArn()));
        case "weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RoutingConfigurationListItem, T> g) {
        return obj -> g.apply((RoutingConfigurationListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingConfigurationListItem> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the routing
         * configuration.
         * </p>
         * <p>
         * If you specify the ARN of a second version, it must belong to the same state machine as the first version.
         * </p>
         * 
         * @param stateMachineVersionArn
         *        The Amazon Resource Name (ARN) that identifies one or two state machine versions defined in the
         *        routing configuration.</p>
         *        <p>
         *        If you specify the ARN of a second version, it must belong to the same state machine as the first
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateMachineVersionArn(String stateMachineVersionArn);

        /**
         * <p>
         * The percentage of traffic you want to route to a state machine version. The sum of the weights in the routing
         * configuration must be equal to 100.
         * </p>
         * 
         * @param weight
         *        The percentage of traffic you want to route to a state machine version. The sum of the weights in the
         *        routing configuration must be equal to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Integer weight);
    }

    static final class BuilderImpl implements Builder {
        private String stateMachineVersionArn;

        private Integer weight;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingConfigurationListItem model) {
            stateMachineVersionArn(model.stateMachineVersionArn);
            weight(model.weight);
        }

        public final String getStateMachineVersionArn() {
            return stateMachineVersionArn;
        }

        public final void setStateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
        }

        @Override
        public final Builder stateMachineVersionArn(String stateMachineVersionArn) {
            this.stateMachineVersionArn = stateMachineVersionArn;
            return this;
        }

        public final Integer getWeight() {
            return weight;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public RoutingConfigurationListItem build() {
            return new RoutingConfigurationListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
