/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTapeWithBarcodeRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, CreateTapeWithBarcodeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTapeWithBarcodeRequest.getter(CreateTapeWithBarcodeRequest::gatewayARN)).setter(CreateTapeWithBarcodeRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(CreateTapeWithBarcodeRequest.getter(CreateTapeWithBarcodeRequest::tapeSizeInBytes)).setter(CreateTapeWithBarcodeRequest.setter(Builder::tapeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()}).build();
    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTapeWithBarcodeRequest.getter(CreateTapeWithBarcodeRequest::tapeBarcode)).setter(CreateTapeWithBarcodeRequest.setter(Builder::tapeBarcode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()}).build();
    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateTapeWithBarcodeRequest.getter(CreateTapeWithBarcodeRequest::kmsEncrypted)).setter(CreateTapeWithBarcodeRequest.setter(Builder::kmsEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTapeWithBarcodeRequest.getter(CreateTapeWithBarcodeRequest::kmsKey)).setter(CreateTapeWithBarcodeRequest.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, TAPE_SIZE_IN_BYTES_FIELD, TAPE_BARCODE_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD));
    private final String gatewayARN;
    private final Long tapeSizeInBytes;
    private final String tapeBarcode;
    private final Boolean kmsEncrypted;
    private final String kmsKey;

    private CreateTapeWithBarcodeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeBarcode = builder.tapeBarcode;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public Long tapeSizeInBytes() {
        return this.tapeSizeInBytes;
    }

    public String tapeBarcode() {
        return this.tapeBarcode;
    }

    public Boolean kmsEncrypted() {
        return this.kmsEncrypted;
    }

    public String kmsKey() {
        return this.kmsKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTapeWithBarcodeRequest)) {
            return false;
        }
        CreateTapeWithBarcodeRequest other = (CreateTapeWithBarcodeRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(this.tapeBarcode(), other.tapeBarcode()) && Objects.equals(this.kmsEncrypted(), other.kmsEncrypted()) && Objects.equals(this.kmsKey(), other.kmsKey());
    }

    public String toString() {
        return ToString.builder((String)"CreateTapeWithBarcodeRequest").add("GatewayARN", (Object)this.gatewayARN()).add("TapeSizeInBytes", (Object)this.tapeSizeInBytes()).add("TapeBarcode", (Object)this.tapeBarcode()).add("KMSEncrypted", (Object)this.kmsEncrypted()).add("KMSKey", (Object)this.kmsKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "TapeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.tapeSizeInBytes()));
            }
            case "TapeBarcode": {
                return Optional.ofNullable(clazz.cast(this.tapeBarcode()));
            }
            case "KMSEncrypted": {
                return Optional.ofNullable(clazz.cast(this.kmsEncrypted()));
            }
            case "KMSKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTapeWithBarcodeRequest, T> g) {
        return obj -> g.apply((CreateTapeWithBarcodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private Long tapeSizeInBytes;
        private String tapeBarcode;
        private Boolean kmsEncrypted;
        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTapeWithBarcodeRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.tapeSizeInBytes(model.tapeSizeInBytes);
            this.tapeBarcode(model.tapeBarcode);
            this.kmsEncrypted(model.kmsEncrypted);
            this.kmsKey(model.kmsKey);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Long getTapeSizeInBytes() {
            return this.tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final String getTapeBarcode() {
            return this.tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        public final Boolean getKmsEncrypted() {
            return this.kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTapeWithBarcodeRequest build() {
            return new CreateTapeWithBarcodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTapeWithBarcodeRequest> {
        public Builder gatewayARN(String var1);

        public Builder tapeSizeInBytes(Long var1);

        public Builder tapeBarcode(String var1);

        public Builder kmsEncrypted(Boolean var1);

        public Builder kmsKey(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

