/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.services.storagegateway.model.TapeARNsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTapesRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, DescribeTapesRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTapesRequest.getter(DescribeTapesRequest::gatewayARN)).setter(DescribeTapesRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<List<String>> TAPE_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTapesRequest.getter(DescribeTapesRequest::tapeARNs)).setter(DescribeTapesRequest.setter(Builder::tapeARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTapesRequest.getter(DescribeTapesRequest::marker)).setter(DescribeTapesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeTapesRequest.getter(DescribeTapesRequest::limit)).setter(DescribeTapesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, TAPE_AR_NS_FIELD, MARKER_FIELD, LIMIT_FIELD));
    private final String gatewayARN;
    private final List<String> tapeARNs;
    private final String marker;
    private final Integer limit;

    private DescribeTapesRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.tapeARNs = builder.tapeARNs;
        this.marker = builder.marker;
        this.limit = builder.limit;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public List<String> tapeARNs() {
        return this.tapeARNs;
    }

    public String marker() {
        return this.marker;
    }

    public Integer limit() {
        return this.limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeARNs());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapesRequest)) {
            return false;
        }
        DescribeTapesRequest other = (DescribeTapesRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.tapeARNs(), other.tapeARNs()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.limit(), other.limit());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTapesRequest").add("GatewayARN", (Object)this.gatewayARN()).add("TapeARNs", this.tapeARNs()).add("Marker", (Object)this.marker()).add("Limit", (Object)this.limit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "TapeARNs": {
                return Optional.ofNullable(clazz.cast(this.tapeARNs()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapesRequest, T> g) {
        return obj -> g.apply((DescribeTapesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private List<String> tapeARNs = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapesRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.tapeARNs(model.tapeARNs);
            this.marker(model.marker);
            this.limit(model.limit);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<String> getTapeARNs() {
            return this.tapeARNs;
        }

        @Override
        public final Builder tapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapeARNs(String ... tapeARNs) {
            this.tapeARNs(Arrays.asList(tapeARNs));
            return this;
        }

        public final void setTapeARNs(Collection<String> tapeARNs) {
            this.tapeARNs = TapeARNsCopier.copy(tapeARNs);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTapesRequest build() {
            return new DescribeTapesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTapesRequest> {
        public Builder gatewayARN(String var1);

        public Builder tapeARNs(Collection<String> var1);

        public Builder tapeARNs(String ... var1);

        public Builder marker(String var1);

        public Builder limit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

