/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.services.storagegateway.model.Tape;
import software.amazon.awssdk.services.storagegateway.model.TapesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTapesResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeTapesResponse> {
    private static final SdkField<List<Tape>> TAPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeTapesResponse.getter(DescribeTapesResponse::tapes)).setter(DescribeTapesResponse.setter(Builder::tapes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tapes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tape::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeTapesResponse.getter(DescribeTapesResponse::marker)).setter(DescribeTapesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPES_FIELD, MARKER_FIELD));
    private final List<Tape> tapes;
    private final String marker;

    private DescribeTapesResponse(BuilderImpl builder) {
        super(builder);
        this.tapes = builder.tapes;
        this.marker = builder.marker;
    }

    public List<Tape> tapes() {
        return this.tapes;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tapes());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTapesResponse)) {
            return false;
        }
        DescribeTapesResponse other = (DescribeTapesResponse)((Object)obj);
        return Objects.equals(this.tapes(), other.tapes()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTapesResponse").add("Tapes", this.tapes()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tapes": {
                return Optional.ofNullable(clazz.cast(this.tapes()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTapesResponse, T> g) {
        return obj -> g.apply((DescribeTapesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private List<Tape> tapes = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTapesResponse model) {
            super(model);
            this.tapes(model.tapes);
            this.marker(model.marker);
        }

        public final Collection<Tape.Builder> getTapes() {
            return this.tapes != null ? (Collection)this.tapes.stream().map(Tape::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tapes(Collection<Tape> tapes) {
            this.tapes = TapesCopier.copy(tapes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapes(Tape ... tapes) {
            this.tapes(Arrays.asList(tapes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tapes(Consumer<Tape.Builder> ... tapes) {
            this.tapes(Stream.of(tapes).map(c -> (Tape)((Tape.Builder)Tape.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTapes(Collection<Tape.BuilderImpl> tapes) {
            this.tapes = TapesCopier.copyFromBuilder(tapes);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTapesResponse build() {
            return new DescribeTapesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTapesResponse> {
        public Builder tapes(Collection<Tape> var1);

        public Builder tapes(Tape ... var1);

        public Builder tapes(Consumer<Tape.Builder> ... var1);

        public Builder marker(String var1);
    }
}

