/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TapeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TapeInfo> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeInfo.getter(TapeInfo::tapeARN)).setter(TapeInfo.setter(Builder::tapeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()}).build();
    private static final SdkField<String> TAPE_BARCODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeInfo.getter(TapeInfo::tapeBarcode)).setter(TapeInfo.setter(Builder::tapeBarcode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeBarcode").build()}).build();
    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(TapeInfo.getter(TapeInfo::tapeSizeInBytes)).setter(TapeInfo.setter(Builder::tapeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()}).build();
    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeInfo.getter(TapeInfo::tapeStatus)).setter(TapeInfo.setter(Builder::tapeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()}).build();
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeInfo.getter(TapeInfo::gatewayARN)).setter(TapeInfo.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD, TAPE_BARCODE_FIELD, TAPE_SIZE_IN_BYTES_FIELD, TAPE_STATUS_FIELD, GATEWAY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tapeARN;
    private final String tapeBarcode;
    private final Long tapeSizeInBytes;
    private final String tapeStatus;
    private final String gatewayARN;

    private TapeInfo(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeBarcode = builder.tapeBarcode;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeStatus = builder.tapeStatus;
        this.gatewayARN = builder.gatewayARN;
    }

    public String tapeARN() {
        return this.tapeARN;
    }

    public String tapeBarcode() {
        return this.tapeBarcode;
    }

    public Long tapeSizeInBytes() {
        return this.tapeSizeInBytes;
    }

    public String tapeStatus() {
        return this.tapeStatus;
    }

    public String gatewayARN() {
        return this.gatewayARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeBarcode());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TapeInfo)) {
            return false;
        }
        TapeInfo other = (TapeInfo)obj;
        return Objects.equals(this.tapeARN(), other.tapeARN()) && Objects.equals(this.tapeBarcode(), other.tapeBarcode()) && Objects.equals(this.tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(this.tapeStatus(), other.tapeStatus()) && Objects.equals(this.gatewayARN(), other.gatewayARN());
    }

    public String toString() {
        return ToString.builder((String)"TapeInfo").add("TapeARN", (Object)this.tapeARN()).add("TapeBarcode", (Object)this.tapeBarcode()).add("TapeSizeInBytes", (Object)this.tapeSizeInBytes()).add("TapeStatus", (Object)this.tapeStatus()).add("GatewayARN", (Object)this.gatewayARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeARN": {
                return Optional.ofNullable(clazz.cast(this.tapeARN()));
            }
            case "TapeBarcode": {
                return Optional.ofNullable(clazz.cast(this.tapeBarcode()));
            }
            case "TapeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.tapeSizeInBytes()));
            }
            case "TapeStatus": {
                return Optional.ofNullable(clazz.cast(this.tapeStatus()));
            }
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TapeInfo, T> g) {
        return obj -> g.apply((TapeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tapeARN;
        private String tapeBarcode;
        private Long tapeSizeInBytes;
        private String tapeStatus;
        private String gatewayARN;

        private BuilderImpl() {
        }

        private BuilderImpl(TapeInfo model) {
            this.tapeARN(model.tapeARN);
            this.tapeBarcode(model.tapeBarcode);
            this.tapeSizeInBytes(model.tapeSizeInBytes);
            this.tapeStatus(model.tapeStatus);
            this.gatewayARN(model.gatewayARN);
        }

        public final String getTapeARN() {
            return this.tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        public final String getTapeBarcode() {
            return this.tapeBarcode;
        }

        @Override
        public final Builder tapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
            return this;
        }

        public final void setTapeBarcode(String tapeBarcode) {
            this.tapeBarcode = tapeBarcode;
        }

        public final Long getTapeSizeInBytes() {
            return this.tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final String getTapeStatus() {
            return this.tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public TapeInfo build() {
            return new TapeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TapeInfo> {
        public Builder tapeARN(String var1);

        public Builder tapeBarcode(String var1);

        public Builder tapeSizeInBytes(Long var1);

        public Builder tapeStatus(String var1);

        public Builder gatewayARN(String var1);
    }
}

