/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TapeRecoveryPointInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TapeRecoveryPointInfo> {
    private static final SdkField<String> TAPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeRecoveryPointInfo.getter(TapeRecoveryPointInfo::tapeARN)).setter(TapeRecoveryPointInfo.setter(Builder::tapeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeARN").build()}).build();
    private static final SdkField<Instant> TAPE_RECOVERY_POINT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TapeRecoveryPointInfo.getter(TapeRecoveryPointInfo::tapeRecoveryPointTime)).setter(TapeRecoveryPointInfo.setter(Builder::tapeRecoveryPointTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeRecoveryPointTime").build()}).build();
    private static final SdkField<Long> TAPE_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(TapeRecoveryPointInfo.getter(TapeRecoveryPointInfo::tapeSizeInBytes)).setter(TapeRecoveryPointInfo.setter(Builder::tapeSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeSizeInBytes").build()}).build();
    private static final SdkField<String> TAPE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TapeRecoveryPointInfo.getter(TapeRecoveryPointInfo::tapeStatus)).setter(TapeRecoveryPointInfo.setter(Builder::tapeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TapeStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAPE_ARN_FIELD, TAPE_RECOVERY_POINT_TIME_FIELD, TAPE_SIZE_IN_BYTES_FIELD, TAPE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tapeARN;
    private final Instant tapeRecoveryPointTime;
    private final Long tapeSizeInBytes;
    private final String tapeStatus;

    private TapeRecoveryPointInfo(BuilderImpl builder) {
        this.tapeARN = builder.tapeARN;
        this.tapeRecoveryPointTime = builder.tapeRecoveryPointTime;
        this.tapeSizeInBytes = builder.tapeSizeInBytes;
        this.tapeStatus = builder.tapeStatus;
    }

    public String tapeARN() {
        return this.tapeARN;
    }

    public Instant tapeRecoveryPointTime() {
        return this.tapeRecoveryPointTime;
    }

    public Long tapeSizeInBytes() {
        return this.tapeSizeInBytes;
    }

    public String tapeStatus() {
        return this.tapeStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeRecoveryPointTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.tapeStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TapeRecoveryPointInfo)) {
            return false;
        }
        TapeRecoveryPointInfo other = (TapeRecoveryPointInfo)obj;
        return Objects.equals(this.tapeARN(), other.tapeARN()) && Objects.equals(this.tapeRecoveryPointTime(), other.tapeRecoveryPointTime()) && Objects.equals(this.tapeSizeInBytes(), other.tapeSizeInBytes()) && Objects.equals(this.tapeStatus(), other.tapeStatus());
    }

    public String toString() {
        return ToString.builder((String)"TapeRecoveryPointInfo").add("TapeARN", (Object)this.tapeARN()).add("TapeRecoveryPointTime", (Object)this.tapeRecoveryPointTime()).add("TapeSizeInBytes", (Object)this.tapeSizeInBytes()).add("TapeStatus", (Object)this.tapeStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TapeARN": {
                return Optional.ofNullable(clazz.cast(this.tapeARN()));
            }
            case "TapeRecoveryPointTime": {
                return Optional.ofNullable(clazz.cast(this.tapeRecoveryPointTime()));
            }
            case "TapeSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.tapeSizeInBytes()));
            }
            case "TapeStatus": {
                return Optional.ofNullable(clazz.cast(this.tapeStatus()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TapeRecoveryPointInfo, T> g) {
        return obj -> g.apply((TapeRecoveryPointInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tapeARN;
        private Instant tapeRecoveryPointTime;
        private Long tapeSizeInBytes;
        private String tapeStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TapeRecoveryPointInfo model) {
            this.tapeARN(model.tapeARN);
            this.tapeRecoveryPointTime(model.tapeRecoveryPointTime);
            this.tapeSizeInBytes(model.tapeSizeInBytes);
            this.tapeStatus(model.tapeStatus);
        }

        public final String getTapeARN() {
            return this.tapeARN;
        }

        @Override
        public final Builder tapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
            return this;
        }

        public final void setTapeARN(String tapeARN) {
            this.tapeARN = tapeARN;
        }

        public final Instant getTapeRecoveryPointTime() {
            return this.tapeRecoveryPointTime;
        }

        @Override
        public final Builder tapeRecoveryPointTime(Instant tapeRecoveryPointTime) {
            this.tapeRecoveryPointTime = tapeRecoveryPointTime;
            return this;
        }

        public final void setTapeRecoveryPointTime(Instant tapeRecoveryPointTime) {
            this.tapeRecoveryPointTime = tapeRecoveryPointTime;
        }

        public final Long getTapeSizeInBytes() {
            return this.tapeSizeInBytes;
        }

        @Override
        public final Builder tapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
            return this;
        }

        public final void setTapeSizeInBytes(Long tapeSizeInBytes) {
            this.tapeSizeInBytes = tapeSizeInBytes;
        }

        public final String getTapeStatus() {
            return this.tapeStatus;
        }

        @Override
        public final Builder tapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
            return this;
        }

        public final void setTapeStatus(String tapeStatus) {
            this.tapeStatus = tapeStatus;
        }

        public TapeRecoveryPointInfo build() {
            return new TapeRecoveryPointInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TapeRecoveryPointInfo> {
        public Builder tapeARN(String var1);

        public Builder tapeRecoveryPointTime(Instant var1);

        public Builder tapeSizeInBytes(Long var1);

        public Builder tapeStatus(String var1);
    }
}

