/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSnapshotScheduleRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateSnapshotScheduleRequest> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSnapshotScheduleRequest.getter(UpdateSnapshotScheduleRequest::volumeARN)).setter(UpdateSnapshotScheduleRequest.setter(Builder::volumeARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()}).build();
    private static final SdkField<Integer> START_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateSnapshotScheduleRequest.getter(UpdateSnapshotScheduleRequest::startAt)).setter(UpdateSnapshotScheduleRequest.setter(Builder::startAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAt").build()}).build();
    private static final SdkField<Integer> RECURRENCE_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateSnapshotScheduleRequest.getter(UpdateSnapshotScheduleRequest::recurrenceInHours)).setter(UpdateSnapshotScheduleRequest.setter(Builder::recurrenceInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurrenceInHours").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSnapshotScheduleRequest.getter(UpdateSnapshotScheduleRequest::description)).setter(UpdateSnapshotScheduleRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD, START_AT_FIELD, RECURRENCE_IN_HOURS_FIELD, DESCRIPTION_FIELD));
    private final String volumeARN;
    private final Integer startAt;
    private final Integer recurrenceInHours;
    private final String description;

    private UpdateSnapshotScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.startAt = builder.startAt;
        this.recurrenceInHours = builder.recurrenceInHours;
        this.description = builder.description;
    }

    public String volumeARN() {
        return this.volumeARN;
    }

    public Integer startAt() {
        return this.startAt;
    }

    public Integer recurrenceInHours() {
        return this.recurrenceInHours;
    }

    public String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.startAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrenceInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSnapshotScheduleRequest)) {
            return false;
        }
        UpdateSnapshotScheduleRequest other = (UpdateSnapshotScheduleRequest)((Object)obj);
        return Objects.equals(this.volumeARN(), other.volumeARN()) && Objects.equals(this.startAt(), other.startAt()) && Objects.equals(this.recurrenceInHours(), other.recurrenceInHours()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSnapshotScheduleRequest").add("VolumeARN", (Object)this.volumeARN()).add("StartAt", (Object)this.startAt()).add("RecurrenceInHours", (Object)this.recurrenceInHours()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeARN": {
                return Optional.ofNullable(clazz.cast(this.volumeARN()));
            }
            case "StartAt": {
                return Optional.ofNullable(clazz.cast(this.startAt()));
            }
            case "RecurrenceInHours": {
                return Optional.ofNullable(clazz.cast(this.recurrenceInHours()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSnapshotScheduleRequest, T> g) {
        return obj -> g.apply((UpdateSnapshotScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String volumeARN;
        private Integer startAt;
        private Integer recurrenceInHours;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSnapshotScheduleRequest model) {
            super(model);
            this.volumeARN(model.volumeARN);
            this.startAt(model.startAt);
            this.recurrenceInHours(model.recurrenceInHours);
            this.description(model.description);
        }

        public final String getVolumeARN() {
            return this.volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final Integer getStartAt() {
            return this.startAt;
        }

        @Override
        public final Builder startAt(Integer startAt) {
            this.startAt = startAt;
            return this;
        }

        public final void setStartAt(Integer startAt) {
            this.startAt = startAt;
        }

        public final Integer getRecurrenceInHours() {
            return this.recurrenceInHours;
        }

        @Override
        public final Builder recurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
            return this;
        }

        public final void setRecurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSnapshotScheduleRequest build() {
            return new UpdateSnapshotScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSnapshotScheduleRequest> {
        public Builder volumeARN(String var1);

        public Builder startAt(Integer var1);

        public Builder recurrenceInHours(Integer var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

