/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.storagegateway.StorageGatewayAsyncClient;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesRequest;
import software.amazon.awssdk.services.storagegateway.model.DescribeVtlDevicesResponse;
import software.amazon.awssdk.services.storagegateway.model.VTLDevice;

public class DescribeVTLDevicesPublisher
implements SdkPublisher<DescribeVtlDevicesResponse> {
    private final StorageGatewayAsyncClient client;
    private final DescribeVtlDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVTLDevicesPublisher(StorageGatewayAsyncClient client, DescribeVtlDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVTLDevicesPublisher(StorageGatewayAsyncClient client, DescribeVtlDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVtlDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVtlDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VTLDevice> vtlDevices() {
        Function<DescribeVtlDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.vtlDevices() != null) {
                return response.vtlDevices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVtlDevicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeVTLDevicesPublisher resume(DescribeVtlDevicesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeVTLDevicesPublisher(this.client, (DescribeVtlDevicesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeVTLDevicesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeVtlDevicesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeVtlDevicesResponseFetcher
    implements AsyncPageFetcher<DescribeVtlDevicesResponse> {
        private DescribeVtlDevicesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVtlDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeVtlDevicesResponse> nextPage(DescribeVtlDevicesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVTLDevicesPublisher.this.client.describeVTLDevices(DescribeVTLDevicesPublisher.this.firstRequest);
            }
            return DescribeVTLDevicesPublisher.this.client.describeVTLDevices((DescribeVtlDevicesRequest)((Object)DescribeVTLDevicesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

